/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.rendition;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;

public class TemplateBasedRenditionProvider
implements RenditionProvider {
    protected static Log log = LogFactory.getLog(TemplateBasedRenditionProvider.class);

    public boolean isAvailable(DocumentModel doc, RenditionDefinition def) {
        TemplateBasedDocument tbd = (TemplateBasedDocument)doc.getAdapter(TemplateBasedDocument.class);
        if (tbd != null) {
            try {
                String template = tbd.getTemplateNameForRendition(def.getName());
                return template != null;
            }
            catch (Exception e) {
                log.error((Object)"Error while testing Rendition Availability", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) throws RenditionException {
        TemplateBasedDocument tbd = (TemplateBasedDocument)doc.getAdapter(TemplateBasedDocument.class);
        try {
            String template = tbd.getTemplateNameForRendition(definition.getName());
            Blob rendered = tbd.renderWithTemplate(template);
            ArrayList<Blob> blobs = new ArrayList<Blob>();
            blobs.add(rendered);
            return blobs;
        }
        catch (Exception e) {
            throw new RenditionException("Unable to render template based Document", e);
        }
    }
}

