/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.tag;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class Tag
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final String label;
    public long weight;
    public static final Comparator<Tag> LABEL_COMPARATOR = new TagLabelComparator();
    public static final Comparator<Tag> WEIGHT_COMPARATOR = new TagWeightComparator();

    public Tag(String label, int weight) {
        this.label = label;
        this.weight = weight;
    }

    public String getLabel() {
        return this.label;
    }

    public long getWeight() {
        return this.weight;
    }

    public void setWeight(long weight) {
        this.weight = weight;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)o);
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.label + ',' + this.weight + ')';
    }

    protected static class TagWeightComparator
    implements Comparator<Tag> {
        protected TagWeightComparator() {
        }

        @Override
        public int compare(Tag t1, Tag t2) {
            return t2.weight < t1.weight ? -1 : (t2.weight == t1.weight ? 0 : 1);
        }
    }

    protected static class TagLabelComparator
    implements Comparator<Tag> {
        protected TagLabelComparator() {
        }

        @Override
        public int compare(Tag t1, Tag t2) {
            return t1.label.compareToIgnoreCase(t2.label);
        }
    }
}

