/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.LocalPackageAsDownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;

public class LocalPackageSource
implements PackageSource {
    protected static final Log log = LogFactory.getLog(LocalPackageSource.class);

    @Override
    public String getName() {
        return "Local";
    }

    @Override
    public String getId() {
        return "local";
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        if (pus == null) {
            log.error((Object)"Unable to locate PackageUpdateService");
            return result;
        }
        try {
            List<LocalPackage> pkgs = pus.getPackages();
            for (LocalPackage pkg : pkgs) {
                result.add(new LocalPackageAsDownloadablePackage(pkg));
            }
        }
        catch (PackageException e) {
            log.error((Object)"Error when getting local packages", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        List<DownloadablePackage> all = this.listPackages();
        if (type == null) {
            return all;
        }
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : all) {
            if (pkg.getType() == null || !pkg.getType().equals((Object)type)) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    public void flushCache() {
    }
}

