/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.identity;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectSecurityError;
import org.nuxeo.connect.identity.Base64;
import org.nuxeo.connect.identity.LogicalInstanceIdentifier;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;

public class SecurityHeaderGenerator {
    public static final String HASH_METHOD = "MD5";

    public static Map<String, String> getHeaders() throws ConnectSecurityError {
        Map<String, String> headers = LogicalInstanceIdentifier.isRegistered() ? SecurityHeaderGenerator.getRegisteredHeaders() : SecurityHeaderGenerator.getAnonymousHeaders();
        return headers;
    }

    protected static Map<String, String> getRegisteredHeaders() throws ConnectSecurityError {
        String digest;
        String TS;
        String CTID;
        String CLID1;
        Map<String, String> headers = SecurityHeaderGenerator.getAnonymousHeaders();
        try {
            CLID1 = LogicalInstanceIdentifier.instance().getCLID1();
            String CLID2 = LogicalInstanceIdentifier.instance().getCLID2();
            CTID = TechnicalInstanceIdentifier.instance().getCTID();
            TS = "" + System.currentTimeMillis();
            String toDigest = CLID2 + CTID + TS;
            digest = Base64.encodeBytes(MessageDigest.getInstance(HASH_METHOD).digest(toDigest.getBytes()));
        }
        catch (Exception e) {
            throw new ConnectSecurityError("Unable to construct Security Headers", e);
        }
        headers.put("X-NUXEO-CONNECT-CLID", CLID1);
        headers.put("X-NUXEO-CONNECT-CTID", CTID);
        headers.put("X-NUXEO-CONNECT-TS", TS);
        headers.put("X-NUXEO-CONNECT-DIGEST", digest);
        headers.put("X-NUXEO-CONNECT-DIGEST-METHOD", HASH_METHOD);
        return headers;
    }

    protected static Map<String, String> getAnonymousHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-NUXEO-CONNECT-CLIENT-VERSION", NuxeoConnectClient.getVersion());
        return headers;
    }
}

