/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import com.ibm.icu.text.CharsetDetector;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;

public class PlainTextPreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    protected String htmlContent(String content) {
        return "<pre>" + content.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("'", "&apos;").replace("\"", "&quot;").replace("\n", "<br/>") + "</pre>";
    }

    @Override
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        byte[] data;
        ArrayList<Blob> blobResults = new ArrayList<Blob>();
        StringBuilder htmlPage = new StringBuilder();
        try {
            data = blob.getByteArray();
        }
        catch (IOException e) {
            throw new PreviewException("Cannot fetch blob content", e);
        }
        String encoding = blob.getEncoding();
        if (encoding == null) {
            CharsetDetector detector = new CharsetDetector();
            detector.setText(data);
            encoding = detector.detect().getName();
        }
        String content = null;
        try {
            content = new String(data, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new PreviewException("Cannot encode blob content to string", e);
        }
        htmlPage.append("<?xml version=\"1.0\" encoding=\"UTF-8\"/>");
        htmlPage.append("<html>");
        htmlPage.append("<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/></head>");
        htmlPage.append("<body>");
        htmlPage.append(this.htmlContent(content));
        htmlPage.append("</body></html>");
        StringBlob mainBlob = new StringBlob(htmlPage.toString(), "text/html", "UTF-8");
        mainBlob.setFilename("index.html");
        blobResults.add((Blob)mainBlob);
        return blobResults;
    }
}

