/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jxls.tag.JxTaglib;
import net.sf.jxls.tag.TagLib;
import org.apache.commons.digester.Digester;

public class Configuration {
    private String metaInfoToken = "//";
    private String startExpressionToken = "${";
    private String endExpressionToken = "}";
    private String startFormulaToken = "$[";
    private String endFormulaToken = "]";
    private String startFormulaPartToken = "{";
    private String endFormulaPartToken = "}";
    private static final String tagPrefix = "jx:";
    private static final String tagPrefixWithBrace = "<jx:";
    private static final String forTagName = "forEach";
    private static final String forTagItems = "items";
    private static final String forTagVar = "var";
    boolean isUTF16 = false;
    private HashMap tagLibs = new HashMap();
    private Digester digester;
    private String jxlsRoot;
    private boolean encodeXMLAttributes = true;
    String sheetKeyName = "sheet";
    String workbookKeyName = "workbook";
    String rowKeyName = "hssfRow";
    String cellKeyName = "hssfCell";
    private String excludeSheetProcessingMark = "#Exclude";
    boolean removeExcludeSheetProcessingMark = false;
    Set excludeSheets = new HashSet();
    public static final String NAMESPACE_URI = "http://jxls.sourceforge.net/jxls";
    public static final String JXLS_ROOT_TAG = "jxls";
    public static final String JXLS_ROOT_START = "<jx:jxls xmlns:jx=\"http://jxls.sourceforge.net/jxls\">";
    public static final String JXLS_ROOT_END = "</jx:jxls>";
    private boolean jexlInnerCollectionsAccess;

    public Configuration() {
        this.registerTagLib(new JxTaglib(), "jx");
    }

    public Configuration(String startExpressionToken, String endExpressionToken, String startFormulaToken, String endFormulaToken, String metaInfoToken) {
        this.startExpressionToken = startExpressionToken;
        this.endExpressionToken = endExpressionToken;
        this.startFormulaToken = startFormulaToken;
        this.endFormulaToken = endFormulaToken;
        this.metaInfoToken = metaInfoToken;
        this.registerTagLib(new JxTaglib(), "jx");
    }

    public Configuration(String startExpressionToken, String endExpressionToken, String startFormulaToken, String endFormulaToken, String metaInfoToken, boolean isUTF16) {
        this.startExpressionToken = startExpressionToken;
        this.endExpressionToken = endExpressionToken;
        this.startFormulaToken = startFormulaToken;
        this.endFormulaToken = endFormulaToken;
        this.metaInfoToken = metaInfoToken;
        this.isUTF16 = isUTF16;
        this.registerTagLib(new JxTaglib(), "jx");
    }

    public boolean isJexlInnerCollectionsAccess() {
        return this.jexlInnerCollectionsAccess;
    }

    public void setJexlInnerCollectionsAccess(boolean jexlInnerCollectionsAccess) {
        this.jexlInnerCollectionsAccess = jexlInnerCollectionsAccess;
    }

    public boolean isUTF16() {
        return this.isUTF16;
    }

    public void setUTF16(boolean UTF16) {
        this.isUTF16 = UTF16;
    }

    public String getSheetKeyName() {
        return this.sheetKeyName;
    }

    public void setSheetKeyName(String sheetKeyName) {
        this.sheetKeyName = sheetKeyName;
    }

    public String getWorkbookKeyName() {
        return this.workbookKeyName;
    }

    public void setWorkbookKeyName(String workbookKeyName) {
        this.workbookKeyName = workbookKeyName;
    }

    public String getRowKeyName() {
        return this.rowKeyName;
    }

    public void setRowKeyName(String rowKeyName) {
        this.rowKeyName = rowKeyName;
    }

    public String getCellKeyName() {
        return this.cellKeyName;
    }

    public void setCellKeyName(String cellKeyName) {
        this.cellKeyName = cellKeyName;
    }

    public String getTagPrefix() {
        return tagPrefix;
    }

    public String getTagPrefixWithBrace() {
        return tagPrefixWithBrace;
    }

    public String getForTagName() {
        return forTagName;
    }

    public String getForTagItems() {
        return forTagItems;
    }

    public String getForTagVar() {
        return forTagVar;
    }

    public String getMetaInfoToken() {
        return this.metaInfoToken;
    }

    public void setMetaInfoToken(String metaInfoToken) {
        this.metaInfoToken = metaInfoToken;
    }

    public String getStartExpressionToken() {
        return this.startExpressionToken;
    }

    public void setStartExpressionToken(String startExpressionToken) {
        this.startExpressionToken = startExpressionToken;
    }

    public String getEndExpressionToken() {
        return this.endExpressionToken;
    }

    public void setEndExpressionToken(String endExpressionToken) {
        this.endExpressionToken = endExpressionToken;
    }

    public String getStartFormulaToken() {
        return this.startFormulaToken;
    }

    public void setStartFormulaToken(String startFormulaToken) {
        this.startFormulaToken = startFormulaToken;
    }

    public String getEndFormulaToken() {
        return this.endFormulaToken;
    }

    public void setEndFormulaToken(String endFormulaToken) {
        this.endFormulaToken = endFormulaToken;
    }

    public String getStartFormulaPartToken() {
        return this.startFormulaPartToken;
    }

    public void setStartFormulaPartToken(String startFormulaPartToken) {
        this.startFormulaPartToken = startFormulaPartToken;
    }

    public String getEndFormulaPartToken() {
        return this.endFormulaPartToken;
    }

    public void setEndFormulaPartToken(String endFormulaPartToken) {
        this.endFormulaPartToken = endFormulaPartToken;
    }

    public String getExcludeSheetProcessingMark() {
        return this.excludeSheetProcessingMark;
    }

    public void setExcludeSheetProcessingMark(String excludeSheetProcessingMark) {
        this.excludeSheetProcessingMark = excludeSheetProcessingMark;
    }

    public boolean isRemoveExcludeSheetProcessingMark() {
        return this.removeExcludeSheetProcessingMark;
    }

    public void setRemoveExcludeSheetProcessingMark(boolean removeExcludeSheetProcessingMark) {
        this.removeExcludeSheetProcessingMark = removeExcludeSheetProcessingMark;
    }

    public void registerTagLib(TagLib tagLib, String namespace) {
        if (this.tagLibs.containsKey(namespace)) {
            throw new RuntimeException("Duplicate tag-lib namespace: " + namespace);
        }
        this.tagLibs.put(namespace, tagLib);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Digester getDigester() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.digester == null) {
                this.initDigester();
            }
        }
        return this.digester;
    }

    private void initDigester() {
        this.digester = new Digester();
        this.digester.setNamespaceAware(true);
        this.digester.setValidating(false);
        StringBuffer sb = new StringBuffer();
        sb.append("<jxls ");
        boolean firstTime = true;
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : this.tagLibs.entrySet()) {
            String namespace = (String)entry2.getKey();
            String namespaceURI = "http://jxls.sourceforge.net/jxls/" + namespace;
            this.digester.setRuleNamespaceURI(namespaceURI);
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(" ");
            }
            sb.append("xmlns:");
            sb.append(namespace);
            sb.append("=\"");
            sb.append(namespaceURI);
            sb.append("\"");
            TagLib tagLib = (TagLib)entry2.getValue();
            Map.Entry tagEntry2 = null;
            for (Map.Entry tagEntry2 : tagLib.getTags().entrySet()) {
                this.digester.addObjectCreate("jxls/" + tagEntry2.getKey(), (String)tagEntry2.getValue());
                this.digester.addSetProperties("jxls/" + tagEntry2.getKey());
            }
        }
        sb.append(">");
        this.jxlsRoot = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJXLSRoot() {
        Configuration configuration = this;
        synchronized (configuration) {
            if (this.jxlsRoot == null) {
                this.initDigester();
            }
        }
        return this.jxlsRoot;
    }

    public Set getExcludeSheets() {
        return this.excludeSheets;
    }

    public void addExcludeSheet(String name) {
        this.excludeSheets.add(name);
    }

    public String getJXLSRootEnd() {
        return "</jxls>";
    }

    public boolean getEncodeXMLAttributes() {
        return this.encodeXMLAttributes;
    }

    public void setEncodeXMLAttributes(boolean encodeXMLAttributes) {
        this.encodeXMLAttributes = encodeXMLAttributes;
    }
}

