/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document;

import fr.opensagres.xdocreport.converter.ConverterRegistry;
import fr.opensagres.xdocreport.converter.IConverter;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IEntryInputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.DocumentContextHelper;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.ProcessState;
import fr.opensagres.xdocreport.document.images.DefaultImageHandler;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.document.preprocessor.IXDocPreprocessor;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.registry.TextStylingRegistry;
import fr.opensagres.xdocreport.template.FieldsExtractor;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateContextHelper;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractXDocReport
implements IXDocReport {
    private static final Logger LOGGER = LogUtils.getLogger((String)AbstractXDocReport.class.getName());
    private static final long serialVersionUID = -6632379345569386476L;
    private Map<String, Collection<IXDocPreprocessor>> preprocessors = new LinkedHashMap<String, Collection<IXDocPreprocessor>>();
    private String id;
    private ITemplateEngine templateEngine;
    private XDocArchive originalArchive = null;
    private XDocArchive preprocessedArchive = null;
    private String[] xmlEntries;
    private FieldsMetadata fieldsMetadata;
    private boolean preprocessed;
    private boolean cacheOriginalDocument = false;
    private Map<String, Object> data = null;
    private long lastModified;
    private Map<String, BufferedElement> elementsCache;

    protected AbstractXDocReport() {
        this.registerPreprocessors();
        this.preprocessed = false;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void load(InputStream sourceStream) throws IOException, XDocReportException {
        if (this.preprocessed) {
            this.preprocessed = false;
        }
        this.setDocumentArchive(XDocArchive.readZip((InputStream)sourceStream));
    }

    @Override
    public void setDocumentArchive(XDocArchive documentArchive) throws IOException, XDocReportException {
        this.lastModified = System.currentTimeMillis();
        this.preprocessed = false;
        if (this.cacheOriginalDocument) {
            this.originalArchive = documentArchive;
            this.preprocessedArchive = documentArchive.createCopy();
        } else {
            this.originalArchive = null;
            this.preprocessedArchive = documentArchive;
        }
        this.doPreprocessorIfNeeded();
    }

    @Override
    public XDocArchive getOriginalDocumentArchive() {
        return this.originalArchive;
    }

    @Override
    public XDocArchive getPreprocessedDocumentArchive() {
        return this.preprocessedArchive;
    }

    @Override
    public ITemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    @Override
    public void setTemplateEngine(ITemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    @Override
    public void addPreprocessor(String entryName, IXDocPreprocessor preprocessor) {
        Collection<IXDocPreprocessor> entryPreprocessors = this.preprocessors.get(entryName);
        if (entryPreprocessors == null) {
            entryPreprocessors = new ArrayList<IXDocPreprocessor>();
            this.preprocessors.put(entryName, entryPreprocessors);
        }
        entryPreprocessors.add(preprocessor);
    }

    @Override
    public void removePreprocessor(String entryName) {
        this.preprocessors.remove(entryName);
    }

    @Override
    public void removeAllPreprocessors() {
        this.preprocessors.clear();
    }

    @Override
    public void setFieldsMetadata(FieldsMetadata fieldsMetadata) {
        this.fieldsMetadata = fieldsMetadata;
        ITemplateEngine templateEngine = this.getTemplateEngine();
        if (templateEngine != null && fieldsMetadata != null) {
            this.fieldsMetadata.setTemplateEngineKind(templateEngine.getKind());
        }
    }

    @Override
    public FieldsMetadata getFieldsMetadata() {
        return this.fieldsMetadata;
    }

    @Override
    public FieldsMetadata createFieldsMetadata() {
        FieldsMetadata fieldsMetadata = new FieldsMetadata();
        this.setFieldsMetadata(fieldsMetadata);
        return fieldsMetadata;
    }

    @Override
    public void preprocess() throws XDocReportException, IOException {
        this.setDocumentArchive(this.getOriginalDocumentArchive());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPreprocessorIfNeeded() throws XDocReportException, IOException {
        if (this.preprocessed) {
            return;
        }
        if (this.templateEngine == null) {
            return;
        }
        HashMap<String, Object> sharedContext = new HashMap<String, Object>();
        if (this.fieldsMetadata != null && this.fieldsMetadata.getFieldsAsTextStyling().size() > 0) {
            this.elementsCache = new HashMap<String, BufferedElement>();
            sharedContext.put("___Elements", this.elementsCache);
        }
        this.onBeforePreprocessing(sharedContext, this.preprocessedArchive);
        try {
            IDocumentFormatter formatter = this.internalGetTemplateEngine().getDocumentFormatter();
            String entryName = null;
            Set<Map.Entry<String, Collection<IXDocPreprocessor>>> preprocessorEntryNames = this.preprocessors.entrySet();
            for (Map.Entry<String, Collection<IXDocPreprocessor>> entry : preprocessorEntryNames) {
                IXDocPreprocessor preprocessor;
                entryName = entry.getKey();
                Collection<IXDocPreprocessor> entryPreprocessors = entry.getValue();
                if (this.preprocessedArchive.hasEntry(entryName)) {
                    for (IXDocPreprocessor preprocessor2 : entryPreprocessors) {
                        preprocessor2.preprocess(entryName, this.preprocessedArchive, this.fieldsMetadata, formatter, sharedContext);
                    }
                    continue;
                }
                Set entriesNameFromWilcard = this.preprocessedArchive.getEntryNames(entryName);
                if (entriesNameFromWilcard.size() > 0) {
                    for (String entryNameFromWilcard : entriesNameFromWilcard) {
                        for (IXDocPreprocessor preprocessor3 : entryPreprocessors) {
                            preprocessor3.preprocess(entryNameFromWilcard, this.preprocessedArchive, this.fieldsMetadata, formatter, sharedContext);
                        }
                    }
                    continue;
                }
                entryPreprocessors = entry.getValue();
                Iterator<Object> i$ = entryPreprocessors.iterator();
                while (i$.hasNext() && !(preprocessor = (IXDocPreprocessor)i$.next()).create(entryName, this.preprocessedArchive, this.fieldsMetadata, formatter, sharedContext)) {
                }
            }
        }
        finally {
            this.onAfterPreprocessing(sharedContext, this.preprocessedArchive);
            this.preprocessed = true;
            sharedContext.clear();
            sharedContext = null;
        }
    }

    protected void onBeforePreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
    }

    protected void onAfterPreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
    }

    public String[] getXMLEntries() {
        return this.xmlEntries;
    }

    public void setXMLEntries(String[] xmlEntries) {
        this.xmlEntries = xmlEntries;
    }

    @Override
    public IContext createContext() throws XDocReportException {
        return this.internalGetTemplateEngine().createContext();
    }

    @Override
    public IContext createContext(Map<String, Object> contextMap) throws XDocReportException {
        return this.internalGetTemplateEngine().createContext(contextMap);
    }

    @Override
    public void process(Map<String, Object> contextMap, OutputStream out) throws XDocReportException, IOException {
        this.process(contextMap, null, out);
    }

    @Override
    public void process(Map<String, Object> contextMap, String entryName, OutputStream out) throws XDocReportException, IOException {
        this.process(this.createContext(contextMap), entryName, out);
    }

    @Override
    public void process(IContext context, OutputStream out) throws XDocReportException, IOException {
        this.process(context, null, out);
    }

    @Override
    public void process(IContext context, String entryName, OutputStream out) throws XDocReportException, IOException {
        long startTime = -1L;
        if (LOGGER.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
            LOGGER.fine("Start process report ");
        }
        XDocArchive outputArchive = null;
        try {
            this.internalGetTemplateEngine();
            this.doPreprocessorIfNeeded();
            outputArchive = this.internalGetDocumentArchive().createCopy();
            this.processTemplateEngine(context, outputArchive);
            this.doPostprocessIfNeeded(outputArchive);
            if (StringUtils.isNotEmpty((String)entryName)) {
                if (!outputArchive.hasEntry(entryName)) {
                    throw new XDocReportException("No entry for the entry name=" + entryName);
                }
                XDocArchive.writeEntry((XDocArchive)outputArchive, (String)entryName, (OutputStream)out);
            } else {
                XDocArchive.writeZip((XDocArchive)outputArchive, (OutputStream)out);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("End process report done with " + (System.currentTimeMillis() - startTime) + "(ms).");
            }
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("End process report with error done with " + (System.currentTimeMillis() - startTime) + "(ms).");
                LOGGER.throwing(this.getClass().getName(), "process", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof XDocReportException) {
                throw (XDocReportException)e;
            }
            throw new XDocReportException(e);
        }
        finally {
            if (outputArchive != null) {
                outputArchive.dispose();
            }
            outputArchive = null;
        }
    }

    protected void doPostprocessIfNeeded(XDocArchive outputArchive) {
    }

    @Override
    public void save(ProcessState processState, OutputStream out) throws IOException, XDocReportException {
        if (processState == ProcessState.PREPROCESSED) {
            XDocArchive.writeZip((XDocArchive)this.preprocessedArchive, (OutputStream)out);
        } else {
            this.checkOriginalArchive();
            XDocArchive.writeZip((XDocArchive)this.originalArchive, (OutputStream)out);
        }
    }

    @Override
    public void saveEntry(String entryName, ProcessState processState, OutputStream out) throws IOException, XDocReportException {
        if (processState == ProcessState.PREPROCESSED) {
            XDocArchive.writeEntry((XDocArchive)this.preprocessedArchive, (String)entryName, (OutputStream)out);
        } else {
            this.checkOriginalArchive();
            XDocArchive.writeEntry((XDocArchive)this.originalArchive, (String)entryName, (OutputStream)out);
        }
    }

    private void checkOriginalArchive() throws XDocReportException {
        if (this.originalArchive == null) {
            throw new XDocReportException("Original document archive is not available. Call IXDocReport#setCacheOriginalDocument(true) before loading document.");
        }
    }

    @Override
    public void extractFields(FieldsExtractor extractor) throws XDocReportException, IOException {
        this.extractFields(extractor, this.internalGetTemplateEngine());
    }

    @Override
    public void extractFields(FieldsExtractor extractor, ITemplateEngine templateEngine) throws XDocReportException, IOException {
        if (templateEngine == null) {
            throw new XDocReportException("ItemplateEngine cannot be null to extract fields.");
        }
        this.doPreprocessorIfNeeded();
        String[] xmlEntries = this.internalGetXMLEntries();
        String entryName = null;
        for (int i = 0; i < xmlEntries.length; ++i) {
            entryName = xmlEntries[i];
            if (this.preprocessedArchive.hasEntry(entryName)) {
                templateEngine.extractFields((IEntryReaderProvider)this.preprocessedArchive, entryName, extractor);
                continue;
            }
            Set entriesNameFromWilcard = this.preprocessedArchive.getEntryNames(entryName);
            for (String entryNameFromWilcard : entriesNameFromWilcard) {
                templateEngine.extractFields((IEntryReaderProvider)this.preprocessedArchive, entryNameFromWilcard, extractor);
            }
        }
    }

    @Override
    public IConverter getConverter(Options options) throws XDocConverterException {
        return ConverterRegistry.getRegistry().findConverter(this.getKind(), options.getTo(), options.getVia());
    }

    @Override
    public void convert(Map<String, Object> contextMap, Options options, OutputStream out) throws XDocReportException, XDocConverterException, IOException {
        this.convert(this.createContext(contextMap), options, out);
    }

    @Override
    public void convert(IContext context, Options options, OutputStream out) throws XDocReportException, XDocConverterException, IOException {
        long startTime = -1L;
        if (LOGGER.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
            LOGGER.fine("Start convert report ");
        }
        XDocArchive outputArchive = null;
        try {
            IConverter converter = this.getConverter(options);
            this.doPreprocessorIfNeeded();
            outputArchive = this.internalGetDocumentArchive().createCopy();
            this.processTemplateEngine(context, outputArchive);
            if (converter.canSupportEntries()) {
                converter.convert((IEntryInputStreamProvider)outputArchive, out, options);
            } else {
                converter.convert(XDocArchive.getInputStream((XDocArchive)outputArchive), out, options);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("End convert report with error done with " + (System.currentTimeMillis() - startTime) + "(ms).");
            }
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("End process report with error done with " + (System.currentTimeMillis() - startTime) + "(ms).");
                LOGGER.throwing(this.getClass().getName(), "convert", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof XDocReportException) {
                throw (XDocReportException)e;
            }
            if (e instanceof XDocConverterException) {
                throw (XDocConverterException)e;
            }
            throw new XDocConverterException(e);
        }
        finally {
            if (outputArchive != null) {
                outputArchive.dispose();
            }
            outputArchive = null;
        }
    }

    private void processTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException, IOException {
        String[] xmlEntries = this.internalGetXMLEntries();
        this.onBeforeProcessTemplateEngine(context, outputArchive);
        String entryName = null;
        for (int i = 0; i < xmlEntries.length; ++i) {
            entryName = xmlEntries[i];
            if (outputArchive.hasEntry(entryName)) {
                this.templateEngine.process(this.getId(), entryName, (IEntryReaderProvider)outputArchive, (IEntryWriterProvider)outputArchive, context);
                continue;
            }
            Set entriesNameFromWilcard = this.internalGetDocumentArchive().getEntryNames(entryName);
            for (String entryNameFromWilcard : entriesNameFromWilcard) {
                this.templateEngine.process(this.getId(), entryNameFromWilcard, (IEntryReaderProvider)outputArchive, (IEntryWriterProvider)outputArchive, context);
            }
        }
        this.onAfterProcessTemplateEngine(context, outputArchive);
    }

    protected void onBeforeProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        DocumentContextHelper.putTextStylingRegistry(context, TextStylingRegistry.getRegistry());
        IImageRegistry imageRegistry = null;
        if (this.fieldsMetadata != null && this.fieldsMetadata.hasFieldsAsImage() && (imageRegistry = this.createImageRegistry((IEntryReaderProvider)outputArchive, (IEntryWriterProvider)outputArchive, (IEntryOutputStreamProvider)outputArchive)) != null) {
            DocumentContextHelper.putImageRegistry(context, imageRegistry);
            if (DocumentContextHelper.getImageHandler(context) == null) {
                DocumentContextHelper.putImageHandler(context, DefaultImageHandler.getInstance());
            }
            imageRegistry.preProcess();
        }
        TemplateContextHelper.putContext((IContext)context);
        if (this.elementsCache != null) {
            DocumentContextHelper.putElementsCache(context, this.elementsCache);
        }
        TemplateContextHelper.putTemplateEngine((IContext)context, (ITemplateEngine)this.templateEngine);
    }

    protected void onAfterProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        IImageRegistry imageRegistry = DocumentContextHelper.getImageRegistry(context);
        if (imageRegistry != null) {
            imageRegistry.postProcess();
        }
    }

    private ITemplateEngine internalGetTemplateEngine() throws XDocReportException {
        if (this.templateEngine == null) {
            throw new XDocReportException("Null template engine. Set template engine with IXDocReport#setTemplateEngine.");
        }
        return this.templateEngine;
    }

    private XDocArchive internalGetDocumentArchive() throws XDocReportException {
        if (this.preprocessedArchive == null) {
            throw new XDocReportException("Null document archive (odt, docx). Load document archive (docx, odt....file) with IXDocReport#load.");
        }
        return this.preprocessedArchive;
    }

    private String[] internalGetXMLEntries() {
        String[] entries = this.getXMLEntries();
        if (entries != null) {
            return entries;
        }
        entries = this.getDefaultXMLEntries();
        if (entries != null) {
            return entries;
        }
        return StringUtils.EMPTY_STRING_ARRAY;
    }

    protected abstract String[] getDefaultXMLEntries();

    @Override
    public void setData(String key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<String, Object>();
        }
        this.data.put(key, value);
    }

    @Override
    public <T> T getData(String key) {
        if (this.data == null) {
            return null;
        }
        return (T)this.data.get(key);
    }

    @Override
    public void clearData(String key) {
        if (this.data == null) {
            return;
        }
        this.data.remove(key);
    }

    @Override
    public void setCacheOriginalDocument(boolean cacheOriginalDocument) {
        this.cacheOriginalDocument = cacheOriginalDocument;
        if (cacheOriginalDocument) {
            if (this.originalArchive == null && this.preprocessedArchive != null) {
                this.originalArchive = this.preprocessedArchive.createCopy();
            }
        } else {
            this.originalArchive = null;
        }
    }

    protected abstract void registerPreprocessors();

    @Override
    public boolean isPreprocessed() {
        return this.preprocessed;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    protected abstract IImageRegistry createImageRegistry(IEntryReaderProvider var1, IEntryWriterProvider var2, IEntryOutputStreamProvider var3);
}

