/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.service;

import java.io.Serializable;
import java.util.ArrayList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

public class RenditionCreator
extends UnrestrictedSessionRunner {
    protected DocumentRef renditionRef;
    protected DocumentModel detachedDendition;
    protected String liveDocumentId;
    protected DocumentRef versionDocumentRef;
    protected Blob renditionBlob;
    protected String renditionName;

    public RenditionCreator(CoreSession session, DocumentModel liveDocument, DocumentModel versionDocument, Blob renditionBlob, String renditionName) {
        super(session);
        this.liveDocumentId = liveDocument.getId();
        this.versionDocumentRef = versionDocument.getRef();
        this.renditionBlob = renditionBlob;
        this.renditionName = renditionName;
    }

    public DocumentRef getRenditionDocumentRef() {
        return this.renditionRef;
    }

    public DocumentModel getDetachedDendition() {
        return this.detachedDendition;
    }

    public void run() throws ClientException {
        DocumentModel versionDocument = this.session.getDocument(this.versionDocumentRef);
        DocumentModel rendition = this.createRenditionDocument(versionDocument);
        this.removeBlobs(rendition);
        this.updateMainBlob(rendition);
        rendition = this.session.createDocument(rendition);
        this.setCorrectVersion(rendition, versionDocument);
        rendition = this.session.saveDocument(rendition);
        DocumentRef renditionCheckoutRef = rendition.getRef();
        this.renditionRef = rendition.checkIn(VersioningOption.NONE, null);
        this.session.removeDocument(renditionCheckoutRef);
        rendition = this.session.getDocument(this.renditionRef);
        this.session.save();
        rendition.detach(true);
        this.detachedDendition = rendition;
    }

    protected DocumentModel createRenditionDocument(DocumentModel versionDocument) throws ClientException {
        DocumentModel rendition = this.session.createDocumentModel(null, versionDocument.getName(), versionDocument.getType());
        rendition.copyContent(versionDocument);
        rendition.getContextData().putScopedValue("initialLifecycleState", (Serializable)((Object)versionDocument.getCurrentLifeCycleState()));
        rendition.addFacet("Rendition");
        rendition.setPropertyValue("rend:sourceId", (Serializable)((Object)versionDocument.getId()));
        rendition.setPropertyValue("rend:sourceVersionableId", (Serializable)((Object)this.liveDocumentId));
        rendition.setPropertyValue("rend:renditionName", (Serializable)((Object)this.renditionName));
        return rendition;
    }

    protected void removeBlobs(DocumentModel rendition) throws ClientException {
        if (rendition.hasSchema("files")) {
            rendition.setPropertyValue("files:files", new ArrayList());
        }
    }

    protected void updateMainBlob(DocumentModel rendition) throws ClientException {
        BlobHolder bh = (BlobHolder)rendition.getAdapter(BlobHolder.class);
        bh.setBlob(this.renditionBlob);
    }

    protected void giveReadRightToUser(DocumentModel rendition) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACLImpl acl = new ACLImpl();
        acp.addACL((ACL)acl);
        ACE ace = new ACE(this.getOriginatingUsername(), "Read", true);
        acl.add((Object)ace);
        rendition.setACP((ACP)acp, true);
    }

    protected void setCorrectVersion(DocumentModel rendition, DocumentModel versionDocument) throws ClientException {
        Long minorVersion = (Long)versionDocument.getPropertyValue("uid:minor_version");
        rendition.setPropertyValue("uid:minor_version", (Serializable)minorVersion);
        rendition.setPropertyValue("uid:major_version", versionDocument.getPropertyValue("uid:major_version"));
    }
}

