/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.listeners;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

public class TemplateInitListener
implements EventListener {
    private static final Log log = LogFactory.getLog(TemplateInitListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (("aboutToCreate".equals(event.getName()) || "beforeDocumentModification".equals(event.getName())) && ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel targetDoc = docCtx.getSourceDocument();
            if (targetDoc.isVersion()) {
                return;
            }
            TemplateSourceDocument templateDoc = (TemplateSourceDocument)targetDoc.getAdapter(TemplateSourceDocument.class);
            if (templateDoc != null) {
                try {
                    templateDoc.initTypesBindings();
                }
                catch (Exception e) {
                    log.error((Object)"Error during type binding automatic initialization", (Throwable)e);
                }
                List params = templateDoc.getParams();
                if (params == null || params.size() == 0) {
                    try {
                        templateDoc.initTemplate(false);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error during parameter automatic initialization", (Throwable)e);
                    }
                }
            } else {
                TemplateBasedDocument tmplBased = (TemplateBasedDocument)targetDoc.getAdapter(TemplateBasedDocument.class);
                if (tmplBased == null) {
                    List tuids;
                    TemplateProcessorService tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class);
                    String targetTemplateUid = (String)((Object)targetDoc.getContextData().getScopedValue(ScopeType.REQUEST, "templateId"));
                    if ("none".equals(targetTemplateUid)) {
                        targetTemplateUid = null;
                    }
                    ArrayList<String> templatesUids = new ArrayList<String>();
                    if (targetTemplateUid != null) {
                        templatesUids.add(targetTemplateUid);
                    }
                    if ((tuids = (List)tps.getTypeMapping().get(targetDoc.getType())) != null) {
                        for (String tuid : tuids) {
                            if (templatesUids.contains(tuid)) continue;
                            templatesUids.add(tuid);
                        }
                    }
                    if (templatesUids.size() > 0) {
                        for (String tuid : templatesUids) {
                            IdRef templateRef = new IdRef(tuid);
                            if (!docCtx.getCoreSession().exists((DocumentRef)templateRef)) continue;
                            DocumentModel sourceTemplateDoc = docCtx.getCoreSession().getDocument((DocumentRef)templateRef);
                            tps.makeTemplateBasedDocument(targetDoc, sourceTemplateDoc, false);
                        }
                    }
                }
            }
        }
    }
}

