/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.textstyling;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.DefaultStyle;
import fr.opensagres.xdocreport.document.docx.textstyling.IDocxStylesGenerator;
import fr.opensagres.xdocreport.document.textstyling.AbstractStylesGenerator;
import fr.opensagres.xdocreport.document.textstyling.Style;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocxDefaultStylesGenerator
extends AbstractStylesGenerator<DefaultStyle>
implements IDocxStylesGenerator {
    public static final IDocxStylesGenerator INSTANCE = new DocxDefaultStylesGenerator();
    private static final Style XDocReport_Hyperlink_Style;
    private static final List<Style> XDocReport_Headings_Style;
    private static final Style XDocReport_AbstractNum_decimal;
    private static final Style XDocReport_AbstractNum_bullet;
    public static final int DocReport_AbstractNumId_decimal = 50;
    public static final int DocReport_AbstractNumId_bullet = 51;

    @Override
    public String generateAllStyles(DefaultStyle defaultStyle) {
        StringBuilder styles = new StringBuilder();
        this.generateHyperlinkStyle(styles, defaultStyle);
        this.generateHeadersStyle(styles, defaultStyle);
        return styles.toString();
    }

    @Override
    public String generateAbstractNumBullet(DefaultStyle defaultStyle) {
        return XDocReport_AbstractNum_bullet.getContent();
    }

    @Override
    public String generateAbstractNumDecimal(DefaultStyle defaultStyle) {
        return XDocReport_AbstractNum_decimal.getContent();
    }

    public void generateHyperlinkStyle(StringBuilder style, DefaultStyle defaultStyle) {
        if (!defaultStyle.hasHyperLinkStyleId()) {
            style.append(XDocReport_Hyperlink_Style.getContent());
        }
    }

    @Override
    public String getHyperLinkStyleId(DefaultStyle defaultStyle) {
        if (defaultStyle == null) {
            return XDocReport_Hyperlink_Style.getId();
        }
        return StringUtils.isNotEmpty((String)defaultStyle.getHyperLinkStyleId()) ? defaultStyle.getHyperLinkStyleId() : XDocReport_Hyperlink_Style.getId();
    }

    public void generateHeadersStyle(StringBuilder styles, DefaultStyle defaultStyle) {
        for (int i = 1; i < DocxDefaultStylesGenerator.getHeaderStylesCount() + 1; ++i) {
            this.generateHeaderStyle(styles, defaultStyle, i);
        }
    }

    public void generateHeaderStyle(StringBuilder styles, DefaultStyle defaultStyle, int level) {
        if (!defaultStyle.hasHeaderStyle(level)) {
            styles.append(XDocReport_Headings_Style.get(level - 1).getContent());
        }
    }

    @Override
    public String getHeaderStyleId(int level, DefaultStyle defaultStyle) {
        if (defaultStyle == null) {
            return this.getDefaultHeaderStyleId(level);
        }
        if (!defaultStyle.hasHeaderStyle(level)) {
            return this.getDefaultHeaderStyleId(level);
        }
        return defaultStyle.getHeaderStyle(level);
    }

    private String getDefaultHeaderStyleId(int level) {
        return XDocReport_Headings_Style.get(level - 1).getId();
    }

    public static int getHeaderStylesCount() {
        return 6;
    }

    @Override
    public Integer getAbstractNumIdForList(boolean ordered, DefaultStyle defaultStyle) {
        Integer abstractNumId;
        if (defaultStyle == null) {
            return ordered ? 50 : 51;
        }
        Integer n = abstractNumId = ordered ? defaultStyle.getAbstractNumIdForOrdererList() : defaultStyle.getAbstractNumIdForUnordererList();
        if (abstractNumId != null) {
            return abstractNumId;
        }
        return ordered ? 50 : 51;
    }

    static {
        XDocReport_Headings_Style = new ArrayList<Style>();
        for (int i = 1; i < DocxDefaultStylesGenerator.getHeaderStylesCount() + 1; ++i) {
            XDocReport_Headings_Style.add(Style.load((String)("XDocReport_Heading_" + i), DocxDefaultStylesGenerator.class));
        }
        XDocReport_Hyperlink_Style = Style.load((String)"XDocReport_Hyperlink", DocxDefaultStylesGenerator.class);
        XDocReport_AbstractNum_decimal = Style.load((String)"XDocReport_AbstractNum_decimal", DocxDefaultStylesGenerator.class);
        XDocReport_AbstractNum_bullet = Style.load((String)"XDocReport_AbstractNum_bullet", DocxDefaultStylesGenerator.class);
    }
}

