/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.html;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.textstyling.properties.ContainerProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.HeaderProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListItemProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ParagraphProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylesHelper {
    public static Map<String, String> parse(String style) {
        if (StringUtils.isEmpty((String)style)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> stylesMap = new HashMap<String, String>();
        String[] styles = style.split(";");
        String s = null;
        int index = 0;
        String name = null;
        String value = null;
        for (int i = 0; i < styles.length; ++i) {
            name = null;
            value = null;
            s = styles[i];
            index = s.indexOf(58);
            if (index == -1) continue;
            name = s.substring(0, index).trim();
            value = s.substring(index + 1, s.length()).trim();
            stylesMap.put(name, value);
        }
        return stylesMap;
    }

    public static ParagraphProperties createParagraphProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            ParagraphProperties properties = new ParagraphProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    public static HeaderProperties createHeaderProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            HeaderProperties properties = new HeaderProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    public static ListItemProperties createListItemProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            ListItemProperties properties = new ListItemProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    public static ListProperties createListProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            ListProperties properties = new ListProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    private static void processContainerproperties(ContainerProperties properties, Map<String, String> stylesMap) {
        properties.setPageBreakBefore(false);
        if ("always".equals(stylesMap.get("page-break-before"))) {
            properties.setPageBreakBefore(true);
        }
        properties.setPageBreakAfter(false);
        if ("always".equals(stylesMap.get("page-break-after"))) {
            properties.setPageBreakAfter(true);
        }
    }
}

