/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.textstyling;

import fr.opensagres.xdocreport.document.odt.textstyling.IODTStylesGenerator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class ODTDefaultStylesGenerator
implements IODTStylesGenerator {
    protected static final String HEADER_PREFIX = "Heading_20_";
    protected static final String[] BULLET_CHARS = new String[]{"\u2022", "\u25e6", "\u25aa"};
    protected static final String OL_STYLE_NAME = "XDocReport_OL";
    protected static final String UL_STYLE_NAME = "XDocReport_UL";
    protected static final String LIST_P_STYLE_NAME_SUFFIX = "_P";
    protected static final double BULLET_STEP = 0.635;
    protected static final String BOLD_STYLE_NAME = "XDocReport_Bold";
    protected static final String ITALIC_STYLE_NAME = "XDocReport_Italic";
    protected static final String BOLD_ITALIC_STYLE_NAME = "XDocReport_BoldItalic";
    protected static final String PAGE_BREAK_BEFORE_PARAGRAPH_STYLE_NAME = "XDocReport_ParaBreakBefore";
    protected static final String PAGE_BREAK_AFTER_PARAGRAPH_STYLE_NAME = "XDocReport_ParaBreakAfter";
    protected static String[] TITLE_FONT_SIZE = new String[]{"115%", "14pt", "14pt", "85%", "85%", "75%"};

    protected String getBulletChar(int level) {
        return BULLET_CHARS[(level - 1) % 3];
    }

    public String getHeaderStyleName(int level) {
        return HEADER_PREFIX + level;
    }

    public String generateHeaderStyle(int level) {
        StringBuilder style = new StringBuilder("<style:style style:name=\"");
        style.append(this.getHeaderStyleName(level));
        style.append("\" style:display-name=\"");
        style.append("Heading " + level);
        style.append("\" style:family=\"paragraph\" style:parent-style-name=\"Heading\" style:next-style-name=\"Text_20_body\" ");
        style.append("style:default-outline-level=\"");
        style.append(level + "\" ");
        style.append("style:class=\"text\"><style:text-properties ");
        style.append("fo:font-size=\"");
        style.append(TITLE_FONT_SIZE[level - 1]);
        style.append("\" fo:font-weight=\"bold\" ");
        if (level % 2 == 0) {
            style.append(" fo:font-style=\"italic\" ");
        }
        style.append("/></style:style>");
        return style.toString();
    }

    public String generateTextStyles() {
        StringBuilder region = new StringBuilder();
        region.append(this.generateStyle(BOLD_STYLE_NAME, true, false));
        region.append(this.generateStyle(ITALIC_STYLE_NAME, false, true));
        region.append(this.generateStyle(BOLD_ITALIC_STYLE_NAME, true, true));
        return region.toString();
    }

    public String generateParagraphStyles() {
        StringBuilder region = new StringBuilder();
        region.append(this.generateStylePageBreak(true));
        region.append(this.generateStylePageBreak(false));
        return region.toString();
    }

    private String generateStyle(String styleName, boolean bold, boolean italic) {
        StringBuilder region = new StringBuilder();
        region.append("<style:style style:name=\"");
        region.append(styleName);
        region.append("\" style:family=\"text\">");
        region.append("<style:text-properties");
        if (bold) {
            region.append(" fo:font-weight=\"bold\"");
        }
        if (italic) {
            region.append(" fo:font-style=\"italic\"");
        }
        region.append("/></style:style>");
        return region.toString();
    }

    public String generateListStyle() {
        StringBuilder region = new StringBuilder();
        region.append(this.generateListStyle(true));
        region.append(this.generateListStyle(false));
        return region.toString();
    }

    protected String generateListStyle(boolean ordered) {
        StringBuilder region = new StringBuilder();
        String styleName = UL_STYLE_NAME;
        if (ordered) {
            styleName = OL_STYLE_NAME;
        }
        region.append("<style:style style:name=\"");
        region.append(styleName + LIST_P_STYLE_NAME_SUFFIX);
        region.append("\" style:family=\"paragraph\" style:parent-style-name=\"Standard\" style:list-style-name=\"");
        region.append(styleName);
        region.append("\"/>");
        region.append("<text:list-style style:name=\"");
        region.append(styleName);
        region.append("\">");
        for (int level = 1; level <= 10; ++level) {
            region.append(this.generateBulletStyle(level, ordered));
        }
        region.append("</text:list-style>");
        return region.toString();
    }

    protected String generateBulletStyle(Integer level, boolean ordered) {
        StringBuilder region = new StringBuilder();
        if (ordered) {
            region.append("<text:list-level-style-number text:level=\"");
        } else {
            region.append("<text:list-level-style-bullet text:level=\"");
        }
        region.append(level.toString());
        region.append("\" text:style-name=\"");
        if (ordered) {
            region.append("Numbering_20_Symbols");
        } else {
            region.append("Bullet_20_Symbols");
        }
        region.append("\" style:num-suffix=\".\" ");
        if (ordered) {
            region.append("style:num-format=\"1\">");
        } else {
            region.append("text:bullet-char=\"" + this.getBulletChar(level) + "\">");
        }
        region.append("<style:list-level-properties text:list-level-position-and-space-mode=\"label-alignment\">");
        region.append("<style:list-level-label-alignment text:label-followed-by=\"listtab\" ");
        DecimalFormatSymbols decimalFormat = new DecimalFormatSymbols();
        decimalFormat.setDecimalSeparator('.');
        String offset = new DecimalFormat("#.###", decimalFormat).format(0.635 * (double)(level + 1));
        region.append(" text:list-tab-stop-position=\"");
        region.append(offset);
        region.append("cm\" fo:text-indent=\"-0.635cm\" fo:margin-left=\"");
        region.append(offset);
        region.append("cm\"/>");
        region.append("</style:list-level-properties>");
        if (ordered) {
            region.append("</text:list-level-style-number>");
        } else {
            region.append("</text:list-level-style-bullet>");
        }
        return region.toString();
    }

    public int getHeaderStylesCount() {
        return 6;
    }

    public int getHeaderStyleNameLevel(String styleName) {
        if (styleName != null && styleName.startsWith(HEADER_PREFIX)) {
            String headerIdx = styleName.substring(11);
            return Integer.parseInt(headerIdx);
        }
        return -1;
    }

    public String getOLStyleName() {
        return OL_STYLE_NAME;
    }

    public String getULStyleName() {
        return UL_STYLE_NAME;
    }

    public String getListItemParagraphStyleNameSuffix() {
        return LIST_P_STYLE_NAME_SUFFIX;
    }

    public String getBoldStyleName() {
        return BOLD_STYLE_NAME;
    }

    public String getItalicStyleName() {
        return ITALIC_STYLE_NAME;
    }

    public String getBoldItalicStyleName() {
        return BOLD_ITALIC_STYLE_NAME;
    }

    public String getParaBreakBeforeStyleName() {
        return PAGE_BREAK_BEFORE_PARAGRAPH_STYLE_NAME;
    }

    public String getParaBreakAfterStyleName() {
        return PAGE_BREAK_AFTER_PARAGRAPH_STYLE_NAME;
    }

    private String generateStylePageBreak(boolean pageBreakBefore) {
        String styleName = pageBreakBefore ? PAGE_BREAK_BEFORE_PARAGRAPH_STYLE_NAME : PAGE_BREAK_AFTER_PARAGRAPH_STYLE_NAME;
        StringBuilder style = new StringBuilder();
        style.append("<style:style style:name=\"");
        style.append(styleName);
        style.append("\" style:family=\"paragraph\" >");
        style.append("<style:paragraph-properties");
        if (pageBreakBefore) {
            style.append(" fo:break-before=\"page\"");
        } else {
            style.append(" fo:break-after=\"page\"");
        }
        style.append(" />");
        style.append("</style:style>");
        return style.toString();
    }
}

