/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.convert;

import java.util.HashMap;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class ConvertHelper {
    protected String findConverter(Blob blob, String destMimeType) throws Exception {
        MimetypeRegistry mtr = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
        String srcMt = mtr.getMimetypeFromFilenameAndBlobWithDefault(blob.getFilename(), blob, blob.getMimeType());
        blob.setMimeType(srcMt);
        ConversionService cs = (ConversionService)Framework.getLocalService(ConversionService.class);
        return cs.getConverterName(srcMt, destMimeType);
    }

    protected Blob applyConverter(Blob blob, String converter, String destMimeType) throws Exception {
        ConversionService cs = (ConversionService)Framework.getLocalService(ConversionService.class);
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("updateDocumentIndex", Boolean.TRUE);
        BlobHolder bh = cs.convert(converter, (BlobHolder)new SimpleBlobHolder(blob), params);
        if (bh == null || bh.getBlob() == null) {
            return blob;
        }
        Blob result = bh.getBlob();
        MimetypeRegistry mtr = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
        String filename = FileUtils.getFileNameNoExt((String)blob.getFilename());
        filename = filename + "." + (String)mtr.getExtensionsFromMimetypeName(destMimeType).get(0);
        result.setFilename(filename);
        return result;
    }

    public Blob convertBlob(Blob blob, String mimeType) throws Exception {
        String converter = this.findConverter(blob, mimeType);
        if (converter != null) {
            return this.applyConverter(blob, converter, mimeType);
        }
        return blob;
    }
}

