/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;

public abstract class AbstractTemplateProcessor
implements TemplateProcessor {
    protected static final int BUFFER_SIZE = 65536;
    protected static final Log log = LogFactory.getLog(AbstractTemplateProcessor.class);

    protected File getWorkingDir() {
        String dirPath = System.getProperty("java.io.tmpdir") + "/NXTemplateProcessor" + System.currentTimeMillis();
        File workingDir = new File(dirPath);
        if (workingDir.exists()) {
            FileUtils.deleteTree((File)workingDir);
        }
        workingDir.mkdir();
        return workingDir;
    }

    protected Blob getSourceTemplateBlob(TemplateBasedDocument templateBasedDocument, String templateName) throws Exception {
        Blob sourceTemplateBlob = templateBasedDocument.getTemplateBlob(templateName);
        return sourceTemplateBlob;
    }
}

