/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.impl;

import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.impl.AbstractRendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;

public class StoredRendition
extends AbstractRendition
implements Rendition {
    protected final DocumentModel stored;

    public StoredRendition(DocumentModel stored, RenditionDefinition definition) {
        super(definition);
        this.stored = stored;
    }

    @Override
    public boolean isStored() {
        return true;
    }

    @Override
    public Blob getBlob() throws RenditionException {
        try {
            return ((BlobHolder)this.stored.getAdapter(BlobHolder.class)).getBlob();
        }
        catch (ClientException e) {
            throw new RenditionException("Unable to get Blob from stored rendition", (Exception)((Object)e));
        }
    }

    @Override
    public List<Blob> getBlobs() throws RenditionException {
        try {
            return ((BlobHolder)this.stored.getAdapter(BlobHolder.class)).getBlobs();
        }
        catch (ClientException e) {
            throw new RenditionException("Unable to get Blobs from stored rendition", (Exception)((Object)e));
        }
    }

    @Override
    public DocumentModel getHostDocument() {
        return this.stored;
    }
}

