/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax;

import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.template.formatter.Directive;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import org.xml.sax.Attributes;

public abstract class MergefieldBufferedRegion
extends BufferedElement {
    private static final String W_P = "w:p";
    private static final String MERGEFORMAT = "\\* MERGEFORMAT";
    private static final String MERGEFIELD_FIELD_TYPE = "MERGEFIELD";
    private static final String HYPERLINK_FIELD_TYPE = "HYPERLINK";
    private final TransformedBufferedDocumentContentHandler handler;
    private String fieldName;
    private BufferedElement tRegion;

    public MergefieldBufferedRegion(TransformedBufferedDocumentContentHandler handler, BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
        this.handler = handler;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String setInstrText(String instrText, FieldMetadata fieldAsTextStyling) {
        this.fieldName = MergefieldBufferedRegion.getFieldName(this, instrText, fieldAsTextStyling, this.handler.getFormatter(), this.handler);
        if (this.fieldName == null) {
            return this.decodeInstrTextIfNeeded(instrText);
        }
        return instrText;
    }

    private String decodeInstrTextIfNeeded(String instrText) {
        String fieldName;
        IDocumentFormatter formatter = this.handler.getFormatter();
        if (formatter == null) {
            return instrText;
        }
        int index = instrText.indexOf(HYPERLINK_FIELD_TYPE);
        if (index != -1 && StringUtils.isNotEmpty((String)(fieldName = instrText.substring(index + HYPERLINK_FIELD_TYPE.length(), instrText.length()).trim()))) {
            if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            if (formatter.containsInterpolation(fieldName = StringUtils.decode((String)fieldName))) {
                return StringUtils.decode((String)instrText);
            }
        }
        return instrText;
    }

    private static String getFieldName(MergefieldBufferedRegion mergefield, String instrText, FieldMetadata fieldAsTextStyling, IDocumentFormatter formatter, TransformedBufferedDocumentContentHandler handler) {
        String fieldName;
        if (StringUtils.isEmpty((String)instrText)) {
            return null;
        }
        int index = instrText.indexOf(MERGEFIELD_FIELD_TYPE);
        if (index != -1 && StringUtils.isNotEmpty((String)(fieldName = instrText.substring(index + MERGEFIELD_FIELD_TYPE.length(), instrText.length()).trim()))) {
            if (fieldName.endsWith(MERGEFORMAT)) {
                fieldName = fieldName.substring(0, fieldName.length() - MERGEFORMAT.length()).trim();
            }
            if (StringUtils.isNotEmpty((String)fieldName)) {
                if (fieldName.startsWith("\"") && fieldName.endsWith("\"")) {
                    fieldName = fieldName.substring(1, fieldName.length() - 1);
                }
                fieldName = StringUtils.replaceAll((String)fieldName, (String)"\\\"", (String)"\"");
                fieldName = StringUtils.xmlUnescape((String)fieldName);
                if (fieldAsTextStyling != null) {
                    long variableIndex = handler.getVariableIndex();
                    BufferedElement parent = mergefield.findParent(W_P);
                    String elementId = handler.registerBufferedElement(variableIndex, parent);
                    String setVariableDirective = formatter.formatAsCallTextStyling(variableIndex, fieldName, DocumentKind.DOCX.name(), fieldAsTextStyling.getSyntaxKind(), fieldAsTextStyling.isSyntaxWithDirective(), elementId, handler.getEntryName());
                    String textBefore = formatter.formatAsTextStylingField(variableIndex, "textBefore");
                    String textBody = formatter.formatAsTextStylingField(variableIndex, "textBody");
                    String textEnd = formatter.formatAsTextStylingField(variableIndex, "textEnd");
                    parent.setContentBeforeStartTagElement(Directive.formatDirective((String)(setVariableDirective + " " + textBefore), (String)handler.getStartNoParse(), (String)handler.getEndNoParse()));
                    parent.setContentAfterEndTagElement(Directive.formatDirective((String)textEnd, (String)handler.getStartNoParse(), (String)handler.getEndNoParse()));
                    return Directive.formatDirective((String)textBody, (String)handler.getStartNoParse(), (String)handler.getEndNoParse());
                }
                return Directive.formatDirective((String)fieldName, (String)handler.getStartNoParse(), (String)handler.getEndNoParse());
            }
        }
        return null;
    }

    public BufferedElement getTRegion() {
        if (this.tRegion == null) {
            this.tRegion = super.findFirstChild("w:t");
        }
        return this.tRegion;
    }
}

