/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.targetplatforms.api.TargetInfo;
import org.nuxeo.targetplatforms.api.TargetPackage;
import org.nuxeo.targetplatforms.api.TargetPackageInfo;
import org.nuxeo.targetplatforms.api.TargetPlatform;
import org.nuxeo.targetplatforms.api.TargetPlatformFilter;
import org.nuxeo.targetplatforms.api.TargetPlatformInfo;
import org.nuxeo.targetplatforms.api.TargetPlatformInstance;
import org.nuxeo.targetplatforms.api.impl.TargetPackageImpl;
import org.nuxeo.targetplatforms.api.impl.TargetPackageInfoImpl;
import org.nuxeo.targetplatforms.api.impl.TargetPlatformFilterImpl;
import org.nuxeo.targetplatforms.api.impl.TargetPlatformImpl;
import org.nuxeo.targetplatforms.api.impl.TargetPlatformInfoImpl;
import org.nuxeo.targetplatforms.api.impl.TargetPlatformInstanceImpl;
import org.nuxeo.targetplatforms.api.service.TargetPlatformService;
import org.nuxeo.targetplatforms.core.descriptors.ServiceConfigurationDescriptor;
import org.nuxeo.targetplatforms.core.descriptors.TargetPackageDescriptor;
import org.nuxeo.targetplatforms.core.descriptors.TargetPlatformDescriptor;
import org.nuxeo.targetplatforms.core.service.DirectoryUpdater;
import org.nuxeo.targetplatforms.core.service.ServiceConfigurationRegistry;
import org.nuxeo.targetplatforms.core.service.TargetPackageRegistry;
import org.nuxeo.targetplatforms.core.service.TargetPlatformRegistry;

public class TargetPlatformServiceImpl
extends DefaultComponent
implements TargetPlatformService {
    private static final Log log = LogFactory.getLog(TargetPlatformServiceImpl.class);
    public static final String XP_CONF = "configuration";
    public static final String XP_PLATFORMS = "platforms";
    public static final String XP_PACKAGES = "packages";
    protected static final DateTimeFormatter dateParser = DateTimeFormat.forPattern((String)"yyyy/MM/dd").withLocale(Locale.ENGLISH).withZone(DateTimeZone.UTC);
    protected ServiceConfigurationRegistry conf;
    protected TargetPlatformRegistry platforms;
    protected TargetPackageRegistry packages;

    public void activate(ComponentContext context) {
        this.platforms = new TargetPlatformRegistry();
        this.packages = new TargetPackageRegistry();
        this.conf = new ServiceConfigurationRegistry();
    }

    public void deactivate(ComponentContext context) {
        this.platforms = null;
        this.packages = null;
        this.conf = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_PLATFORMS.equals(extensionPoint)) {
            TargetPlatformDescriptor desc = (TargetPlatformDescriptor)contribution;
            log.info((Object)String.format("Register target platform '%s'", desc.getId()));
            this.platforms.addContribution(desc);
        } else if (XP_PACKAGES.equals(extensionPoint)) {
            TargetPackageDescriptor desc = (TargetPackageDescriptor)contribution;
            log.info((Object)String.format("Register target package '%s'", desc.getId()));
            this.packages.addContribution(desc);
        } else if (XP_CONF.equals(extensionPoint)) {
            ServiceConfigurationDescriptor desc = (ServiceConfigurationDescriptor)contribution;
            log.info((Object)String.format("Register TargetPlatformService configuration", new Object[0]));
            this.conf.addContribution(desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_PLATFORMS.equals(extensionPoint)) {
            TargetPlatformDescriptor desc = (TargetPlatformDescriptor)contribution;
            log.info((Object)String.format("Unregister target platform '%s'", desc.getId()));
            this.platforms.removeContribution(desc);
        } else if (XP_PACKAGES.equals(extensionPoint)) {
            TargetPackageDescriptor desc = (TargetPackageDescriptor)contribution;
            log.info((Object)String.format("Unregister target package '%s'", desc.getId()));
            this.packages.removeContribution(desc);
        } else if (XP_CONF.equals(extensionPoint)) {
            ServiceConfigurationDescriptor desc = (ServiceConfigurationDescriptor)contribution;
            log.info((Object)String.format("Unregister TargetPlatformService configuration", new Object[0]));
            this.conf.removeContribution(desc);
        }
    }

    public TargetPlatform getDefaultTargetPlatform(TargetPlatformFilter filter) throws ClientException {
        List<TargetPlatform> tps = this.getAvailableTargetPlatforms(filter);
        if (tps.isEmpty()) {
            return null;
        }
        TargetPlatform defaultTP = null;
        for (TargetPlatform tp : tps) {
            if (!tp.isDefault()) continue;
            if (!tp.isRestricted()) {
                return tp;
            }
            if (defaultTP != null) continue;
            defaultTP = tp;
        }
        return defaultTP;
    }

    public String getOverrideDirectory() {
        String res = "targetPlatformOverrides";
        ServiceConfigurationDescriptor desc = this.conf.getConfiguration();
        if (desc == null) {
            return res;
        }
        String id = desc.getOverrideDirectory();
        if (!StringUtils.isBlank((String)id)) {
            res = id;
        }
        return res;
    }

    public TargetPlatform getTargetPlatform(String id) throws ClientException {
        if (id == null) {
            return null;
        }
        TargetPlatformDescriptor desc = this.platforms.getTargetPlatform(id);
        return this.getTargetPlatform(desc);
    }

    protected TargetPlatform getTargetPlatform(TargetPlatformDescriptor desc) throws ClientException {
        if (desc == null) {
            return null;
        }
        String id = desc.getId();
        TargetPlatformImpl tp = new TargetPlatformImpl(id, desc.getName(), desc.getVersion(), desc.getRefVersion(), desc.getLabel());
        tp.setDeprecated(desc.isDeprecated());
        tp.setDescription(desc.getDescription());
        tp.setDownloadLink(desc.getDownloadLink());
        tp.setEnabled(desc.isEnabled());
        tp.setEndOfAvailability(this.toDate(desc.getEndOfAvailability()));
        tp.setFastTrack(desc.isFastTrack());
        tp.setTrial(desc.isTrial());
        tp.setDefault(desc.isDefault());
        tp.setParent(this.getTargetPlatform(desc.getParent()));
        tp.setRefVersion(desc.getRefVersion());
        tp.setReleaseDate(this.toDate(desc.getReleaseDate()));
        tp.setRestricted(desc.isRestricted());
        tp.setStatus(desc.getStatus());
        tp.setTestVersions(desc.getTestVersions());
        tp.setTypes(desc.getTypes());
        tp.setAvailablePackages(this.getTargetPackages(id));
        DocumentModel entry = this.getDirectoryEntry(id);
        if (entry != null) {
            Long isDefault;
            Long trial;
            Long deprecated;
            Long restricted;
            Long enabled = (Long)entry.getProperty("target_platform_override", "enabled");
            if (enabled != null && enabled.intValue() >= 0) {
                tp.setEnabled(enabled.intValue() != 0);
            }
            if ((restricted = (Long)entry.getProperty("target_platform_override", "restricted")) != null && restricted.intValue() >= 0) {
                tp.setRestricted(restricted.intValue() != 0);
            }
            if ((deprecated = (Long)entry.getProperty("target_platform_override", "deprecated")) != null && deprecated.intValue() >= 0) {
                tp.setDeprecated(deprecated.intValue() != 0);
            }
            if ((trial = (Long)entry.getProperty("target_platform_override", "trial")) != null && trial.intValue() >= 0) {
                tp.setTrial(trial.intValue() != 0);
            }
            if ((isDefault = (Long)entry.getProperty("target_platform_override", "default")) != null && isDefault.intValue() >= 0) {
                tp.setDefault(isDefault.intValue() != 0);
            }
            tp.setOverridden(true);
        }
        return tp;
    }

    protected Map<String, TargetPackage> getTargetPackages(String targetPlatform) {
        HashMap<String, TargetPackage> tps = new HashMap<String, TargetPackage>();
        List<TargetPackageDescriptor> pkgs = this.packages.getTargetPackages(targetPlatform);
        if (pkgs != null) {
            for (TargetPackageDescriptor pkg : pkgs) {
                TargetPackage tp = this.getTargetPackage(pkg);
                if (tp == null) continue;
                tps.put(tp.getId(), tp);
            }
        }
        return tps;
    }

    protected Map<String, TargetPackageInfo> getTargetPackagesInfo(String targetPlatform) {
        HashMap<String, TargetPackageInfo> tps = new HashMap<String, TargetPackageInfo>();
        List<TargetPackageDescriptor> pkgs = this.packages.getTargetPackages(targetPlatform);
        if (pkgs != null) {
            for (TargetPackageDescriptor pkg : pkgs) {
                TargetPackageInfo tp = this.getTargetPackageInfo(pkg.getId());
                if (tp == null) continue;
                tps.put(tp.getId(), tp);
            }
        }
        return tps;
    }

    protected Date toDate(String date) {
        if (StringUtils.isBlank((String)date)) {
            return null;
        }
        DateTime dt = dateParser.parseDateTime(date);
        return dt.toDate();
    }

    public TargetPlatformInfo getTargetPlatformInfo(String id) throws ClientException {
        if (id == null) {
            return null;
        }
        TargetPlatformDescriptor desc = this.platforms.getTargetPlatform(id);
        TargetPlatformInfo tpi = this.getTargetPlatformInfo(desc);
        return tpi;
    }

    protected TargetPlatformInfo getTargetPlatformInfo(TargetPlatformDescriptor desc) throws ClientException {
        if (desc == null) {
            return null;
        }
        String id = desc.getId();
        TargetPlatformInfoImpl tpi = new TargetPlatformInfoImpl(id, desc.getName(), desc.getVersion(), desc.getRefVersion(), desc.getLabel());
        tpi.setDescription(desc.getDescription());
        tpi.setStatus(desc.getStatus());
        tpi.setEnabled(desc.isEnabled());
        tpi.setFastTrack(desc.isFastTrack());
        tpi.setReleaseDate(this.toDate(desc.getReleaseDate()));
        tpi.setRestricted(desc.isRestricted());
        tpi.setEndOfAvailability(this.toDate(desc.getEndOfAvailability()));
        tpi.setDownloadLink(desc.getDownloadLink());
        tpi.setDeprecated(desc.isDeprecated());
        tpi.setAvailablePackagesInfo(this.getTargetPackagesInfo(id));
        tpi.setTypes(desc.getTypes());
        tpi.setTrial(desc.isTrial());
        tpi.setDefault(desc.isDefault());
        DocumentModel entry = this.getDirectoryEntry(id);
        if (entry != null) {
            Long isDefault;
            Long trial;
            Long deprecated;
            Long restricted;
            Long enabled = (Long)entry.getProperty("target_platform_override", "enabled");
            if (enabled != null && enabled.intValue() >= 0) {
                tpi.setEnabled(enabled.intValue() != 0);
            }
            if ((restricted = (Long)entry.getProperty("target_platform_override", "restricted")) != null && restricted.intValue() >= 0) {
                tpi.setRestricted(restricted.intValue() != 0);
            }
            if ((deprecated = (Long)entry.getProperty("target_platform_override", "deprecated")) != null && deprecated.intValue() >= 0) {
                tpi.setDeprecated(deprecated.intValue() != 0);
            }
            if ((trial = (Long)entry.getProperty("target_platform_override", "trial")) != null && trial.intValue() >= 0) {
                tpi.setTrial(trial.intValue() != 0);
            }
            if ((isDefault = (Long)entry.getProperty("target_platform_override", "default")) != null && isDefault.intValue() >= 0) {
                tpi.setDefault(isDefault.intValue() != 0);
            }
            tpi.setOverridden(true);
        }
        return tpi;
    }

    public TargetPackage getTargetPackage(String id) {
        if (id == null) {
            return null;
        }
        return this.getTargetPackage(this.packages.getTargetPackage(id));
    }

    public TargetPackageInfo getTargetPackageInfo(String id) {
        if (id == null) {
            return null;
        }
        TargetPackageDescriptor desc = this.packages.getTargetPackage(id);
        TargetPackageInfoImpl tpi = new TargetPackageInfoImpl(desc.getId(), desc.getName(), desc.getVersion(), desc.getRefVersion(), desc.getLabel());
        tpi.setDescription(desc.getDescription());
        tpi.setStatus(desc.getStatus());
        tpi.setEnabled(desc.isEnabled());
        tpi.setReleaseDate(this.toDate(desc.getReleaseDate()));
        tpi.setRestricted(desc.isRestricted());
        tpi.setEndOfAvailability(this.toDate(desc.getEndOfAvailability()));
        tpi.setDownloadLink(desc.getDownloadLink());
        tpi.setDeprecated(desc.isDeprecated());
        tpi.setDependencies(desc.getDependencies());
        return tpi;
    }

    protected TargetPackage getTargetPackage(TargetPackageDescriptor desc) {
        if (desc == null) {
            return null;
        }
        TargetPackageImpl tp = new TargetPackageImpl(desc.getId(), desc.getName(), desc.getVersion(), desc.getRefVersion(), desc.getLabel());
        tp.setDependencies(desc.getDependencies());
        tp.setDeprecated(desc.isDeprecated());
        tp.setDescription(desc.getDescription());
        tp.setDownloadLink(desc.getDownloadLink());
        tp.setEnabled(desc.isEnabled());
        tp.setEndOfAvailability(this.toDate(desc.getEndOfAvailability()));
        tp.setParent(this.getTargetPackage(desc.getParent()));
        tp.setRefVersion(desc.getRefVersion());
        tp.setReleaseDate(this.toDate(desc.getReleaseDate()));
        tp.setRestricted(desc.isRestricted());
        tp.setStatus(desc.getStatus());
        tp.setTypes(desc.getTypes());
        return tp;
    }

    public TargetPlatformInstance getTargetPlatformInstance(String id, List<String> packages) throws ClientException {
        if (id == null) {
            return null;
        }
        TargetPlatformInstanceImpl tpi = this.createTargetPlatformInstanceFromId(id);
        if (packages != null) {
            for (String pkg : packages) {
                TargetPackage tpkg = this.getTargetPackage(pkg);
                if (tpkg != null) {
                    tpi.addEnabledPackage(tpkg);
                    continue;
                }
                log.warn((Object)String.format("Referenced target package '%s' not found.", pkg));
            }
        }
        return tpi;
    }

    public List<TargetPlatform> getAvailableTargetPlatforms(TargetPlatformFilter filter) throws ClientException {
        ArrayList<TargetPlatform> tps = new ArrayList<TargetPlatform>();
        for (TargetPlatformDescriptor desc : this.platforms.getTargetPlatforms()) {
            TargetPlatform tp = this.getTargetPlatform(desc);
            if (tp == null || filter != null && !filter.accepts((TargetInfo)tp)) continue;
            tps.add(tp);
        }
        Collections.sort(tps, new Comparator<TargetPlatform>(){

            @Override
            public int compare(TargetPlatform arg0, TargetPlatform arg1) {
                return arg0.getId().compareTo(arg1.getId());
            }
        });
        return tps;
    }

    public List<TargetPlatformInfo> getAvailableTargetPlatformsInfo(TargetPlatformFilter filter) throws ClientException {
        ArrayList<TargetPlatformInfo> tps = new ArrayList<TargetPlatformInfo>();
        for (TargetPlatformDescriptor desc : this.platforms.getTargetPlatforms()) {
            TargetPlatformInfo tp = this.getTargetPlatformInfo(desc);
            if (tp == null || filter != null && !filter.accepts((TargetInfo)tp)) continue;
            tps.add(tp);
        }
        Collections.sort(tps, new Comparator<TargetPlatformInfo>(){

            @Override
            public int compare(TargetPlatformInfo arg0, TargetPlatformInfo arg1) {
                return arg0.getId().compareTo(arg1.getId());
            }
        });
        return tps;
    }

    public void deprecateTargetPlatform(boolean deprecate, String id) throws ClientException {
        Integer val = deprecate ? Integer.valueOf(1) : Integer.valueOf(0);
        this.updateOrCreateEntry(id, "deprecated", val);
    }

    public void enableTargetPlatform(boolean enable, String id) throws ClientException {
        Integer val = enable ? Integer.valueOf(1) : Integer.valueOf(0);
        this.updateOrCreateEntry(id, "enabled", val);
    }

    public void restrictTargetPlatform(boolean restrict, String id) throws ClientException {
        Integer val = restrict ? Integer.valueOf(1) : Integer.valueOf(0);
        this.updateOrCreateEntry(id, "restricted", val);
    }

    public void setTrialTargetPlatform(boolean trial, String id) throws ClientException {
        Integer val = trial ? Integer.valueOf(1) : Integer.valueOf(0);
        this.updateOrCreateEntry(id, "trial", val);
    }

    public void setDefaultTargetPlatform(boolean isDefault, String id) throws ClientException {
        Integer val = isDefault ? Integer.valueOf(1) : Integer.valueOf(0);
        this.updateOrCreateEntry(id, "default", val);
    }

    public void restoreTargetPlatform(final String id) throws ClientException {
        new DirectoryUpdater(this.getOverrideDirectory()){

            @Override
            public void run(DirectoryService service, Session session) throws ClientException {
                session.deleteEntry(id);
            }
        }.run();
    }

    public void restoreAllTargetPlatforms() throws ClientException {
        new DirectoryUpdater(this.getOverrideDirectory()){

            @Override
            public void run(DirectoryService service, Session session) throws ClientException {
                for (DocumentModel entry : session.getEntries()) {
                    session.deleteEntry(entry.getId());
                }
            }
        }.run();
    }

    protected void updateOrCreateEntry(final String id, final String prop, final Integer value) throws ClientException {
        new DirectoryUpdater(this.getOverrideDirectory()){

            @Override
            public void run(DirectoryService service, Session session) throws ClientException {
                DocumentModel doc = session.getEntry(id);
                if (doc != null) {
                    doc.setProperty("target_platform_override", prop, (Object)value);
                    session.updateEntry(doc);
                } else {
                    DocumentModel entry = BaseSession.createEntryModel(null, (String)"target_platform_override", null, null);
                    entry.setProperty("target_platform_override", prop, (Object)value);
                    entry.setProperty("target_platform_override", "id", (Object)id);
                    session.createEntry(entry);
                }
            }
        }.run();
    }

    protected DocumentModel getDirectoryEntry(String id) throws ClientException {
        try (Session dirSession = null;){
            DirectoryService dirService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            String dirName = this.getOverrideDirectory();
            dirSession = dirService.open(dirName);
            DocumentModel documentModel = dirSession.getEntry(id);
            return documentModel;
        }
    }

    public TargetPlatformInstance getDefaultTargetPlatformInstance(boolean restricted) throws ClientException {
        TargetPlatformInstanceImpl tpi = null;
        TargetPlatformFilterImpl filter = new TargetPlatformFilterImpl();
        filter.setFilterRestricted(restricted);
        TargetPlatform defaultTP = this.getDefaultTargetPlatform((TargetPlatformFilter)filter);
        if (defaultTP != null) {
            tpi = this.createTargetPlatformInstanceFromId(defaultTP.getId());
        }
        return tpi;
    }

    protected TargetPlatformInstanceImpl createTargetPlatformInstanceFromId(String id) throws ClientException {
        TargetPlatformDescriptor desc = this.platforms.getTargetPlatform(id);
        if (desc == null) {
            return null;
        }
        TargetPlatformInstanceImpl tpi = new TargetPlatformInstanceImpl(id, desc.getName(), desc.getVersion(), desc.getRefVersion(), desc.getLabel());
        tpi.setDeprecated(desc.isDeprecated());
        tpi.setDescription(desc.getDescription());
        tpi.setDownloadLink(desc.getDownloadLink());
        tpi.setEnabled(desc.isEnabled());
        tpi.setEndOfAvailability(this.toDate(desc.getEndOfAvailability()));
        tpi.setFastTrack(desc.isFastTrack());
        tpi.setParent(this.getTargetPlatform(desc.getParent()));
        tpi.setRefVersion(desc.getRefVersion());
        tpi.setReleaseDate(this.toDate(desc.getReleaseDate()));
        tpi.setRestricted(desc.isRestricted());
        tpi.setStatus(desc.getStatus());
        tpi.setTypes(desc.getTypes());
        DocumentModel entry = this.getDirectoryEntry(id);
        if (entry != null) {
            Long deprecated;
            Long restricted;
            Long enabled = (Long)entry.getProperty("target_platform_override", "enabled");
            if (enabled != null && enabled.intValue() >= 0) {
                tpi.setEnabled(enabled.intValue() != 0);
            }
            if ((restricted = (Long)entry.getProperty("target_platform_override", "restricted")) != null && restricted.intValue() >= 0) {
                tpi.setRestricted(restricted.intValue() != 0);
            }
            if ((deprecated = (Long)entry.getProperty("target_platform_override", "deprecated")) != null && deprecated.intValue() >= 0) {
                tpi.setDeprecated(deprecated.intValue() != 0);
            }
            tpi.setOverridden(true);
        }
        return tpi;
    }
}

