/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.core.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.runtime.model.SimpleContributionRegistry;
import org.nuxeo.targetplatforms.core.descriptors.TargetPackageDescriptor;

public class TargetPackageRegistry
extends SimpleContributionRegistry<TargetPackageDescriptor> {
    public String getContributionId(TargetPackageDescriptor contrib) {
        return contrib.getId();
    }

    public void contributionUpdated(String id, TargetPackageDescriptor contrib, TargetPackageDescriptor newOrigContrib) {
        if (this.currentContribs.containsKey(id)) {
            this.currentContribs.remove(id);
        }
        this.currentContribs.put(id, contrib);
    }

    public boolean isSupportingMerge() {
        return true;
    }

    public TargetPackageDescriptor clone(TargetPackageDescriptor orig) {
        return orig.clone();
    }

    public void merge(TargetPackageDescriptor src, TargetPackageDescriptor dst) {
        if (src.isEnableSet() && src.isEnabled() != dst.isEnabled()) {
            dst.setEnabled(src.isEnabled());
        }
    }

    public TargetPackageDescriptor getTargetPackage(String id) {
        return (TargetPackageDescriptor)this.currentContribs.get(id);
    }

    public List<TargetPackageDescriptor> getTargetPackages() {
        ArrayList<TargetPackageDescriptor> all = new ArrayList<TargetPackageDescriptor>();
        all.addAll(this.currentContribs.values());
        return all;
    }

    public List<TargetPackageDescriptor> getTargetPackages(String targetPlatform) {
        ArrayList<TargetPackageDescriptor> tps = new ArrayList<TargetPackageDescriptor>();
        for (TargetPackageDescriptor desc : this.currentContribs.values()) {
            List<String> tts = desc.getTargetPlatforms();
            if (tts == null || !tts.contains(targetPlatform)) continue;
            tps.add(desc);
        }
        return tps;
    }
}

