/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.ecm.spaces.api.Space;
import org.nuxeo.ecm.spaces.helper.WebContentHelper;
import org.nuxeo.opensocial.container.shared.layout.api.LayoutHelper;
import org.nuxeo.runtime.api.Framework;

public class InitializeSocialWorkspaceDashboardsListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (Framework.isTestModeSet()) {
            return;
        }
        if (!"documentCreated".equals(event.getName())) {
            return;
        }
        EventContext eventContext = event.getContext();
        if (eventContext instanceof DocumentEventContext) {
            DocumentEventContext documentEventContext = (DocumentEventContext)eventContext;
            DocumentModel doc = documentEventContext.getSourceDocument();
            if (!"Space".equals(doc.getType()) || doc.isProxy()) {
                return;
            }
            SocialWorkspace socialWorkspace = InitializeSocialWorkspaceDashboardsListener.getSocialWorkspaceService().getDetachedSocialWorkspace(doc);
            if (socialWorkspace != null) {
                InitializeSocialWorkspaceDashboardsListener.initializeDashboards(documentEventContext.getCoreSession(), doc, socialWorkspace);
            }
        }
    }

    private static void initializeDashboards(CoreSession session, DocumentModel doc, SocialWorkspace socialWorkspace) throws ClientException {
        Locale locale;
        try {
            locale = LocaleSelector.instance().getLocale();
        }
        catch (Exception e) {
            locale = Locale.ENGLISH;
        }
        Map<String, String> additionalPreferences = InitializeSocialWorkspaceDashboardsListener.buildAdditionalPreferences(socialWorkspace);
        if ("privateDashboardSpace".equals(doc.getName())) {
            InitializeSocialWorkspaceDashboardsListener.initializePrivateDashboard(doc, session, locale, additionalPreferences);
        } else if ("publicDashboardSpace".equals(doc.getName())) {
            InitializeSocialWorkspaceDashboardsListener.initializePublicDashboard(doc, session, locale, additionalPreferences);
        }
    }

    private static Map<String, String> buildAdditionalPreferences(SocialWorkspace socialWorkspace) {
        HashMap<String, String> additionalPreferences = new HashMap<String, String>();
        additionalPreferences.put("nuxeoTargetRepository", socialWorkspace.getDocument().getRepositoryName());
        additionalPreferences.put("nuxeoTargetContextPath", socialWorkspace.getPath());
        additionalPreferences.put("nuxeoTargetContextObject", socialWorkspace.getDocument().getType());
        return additionalPreferences;
    }

    private static void initializePrivateDashboard(DocumentModel doc, CoreSession session, Locale locale, Map<String, String> additionalPreferences) throws ClientException {
        Space space = (Space)doc.getAdapter(Space.class);
        space.initLayout(LayoutHelper.buildLayout((LayoutHelper.Preset)LayoutHelper.Preset.X_3_DEFAULT));
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"news", (int)0, (int)0, (int)0, additionalPreferences);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"articles", (int)0, (int)0, (int)1, additionalPreferences);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"members", (int)0, (int)0, (int)2, additionalPreferences);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"library", (int)0, (int)1, (int)0, additionalPreferences);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"socialworkspaceminimessages", (int)0, (int)2, (int)0, additionalPreferences);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"socialworkspaceactivitystream", (int)0, (int)2, (int)1, additionalPreferences);
    }

    private static void initializePublicDashboard(DocumentModel doc, CoreSession session, Locale locale, Map<String, String> additionalPreferences) throws ClientException {
        Space space = (Space)doc.getAdapter(Space.class);
        space.initLayout(LayoutHelper.buildLayout((LayoutHelper.Preset)LayoutHelper.Preset.X_2_66_33));
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"news", (int)0, (int)0, (int)0, additionalPreferences);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"publicarticles", (int)0, (int)0, (int)1, additionalPreferences);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"join", (int)0, (int)1, (int)0, additionalPreferences);
        WebContentHelper.createOpenSocialGadget((Space)space, (CoreSession)session, (Locale)locale, (String)"publicdocuments", (int)0, (int)1, (int)1, additionalPreferences);
    }

    private static SocialWorkspaceService getSocialWorkspaceService() {
        try {
            return (SocialWorkspaceService)Framework.getService(SocialWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

