/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree;

import de.odysseus.el.tree.Tree;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeBuilderException;
import de.odysseus.el.tree.TreeCache;

public class TreeStore {
    private final TreeCache cache;
    private final TreeBuilder builder;

    public TreeStore(TreeBuilder builder, TreeCache cache) {
        this.builder = builder;
        this.cache = cache;
    }

    public TreeBuilder getBuilder() {
        return this.builder;
    }

    public Tree get(String expression) throws TreeBuilderException {
        if (this.cache == null) {
            return this.builder.build(expression);
        }
        Tree tree = this.cache.get(expression);
        if (tree == null) {
            tree = this.builder.build(expression);
            this.cache.put(expression, tree);
        }
        return tree;
    }
}

