/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableSet;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import org.apache.shindig.gadgets.templates.TemplateContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateELResolver
extends ELResolver {
    public static final String PROPERTY_TOP = "Top";
    public static final String PROPERTY_CONTEXT = "Context";
    public static final String PROPERTY_CUR = "Cur";
    public static final String PROPERTY_MY = "My";
    private static final Set<String> TOP_LEVEL_PROPERTIES = ImmutableSet.of((Object)"Top", (Object)"Context", (Object)"Cur", (Object)"My");
    private final TemplateContext templateContext;

    public TemplateELResolver(TemplateContext templateContext) {
        this.templateContext = templateContext;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return String.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            Map<String, Object> scope;
            ValueExpression valueExp;
            if (TOP_LEVEL_PROPERTIES.contains(property)) {
                context.setPropertyResolved(true);
                if (PROPERTY_TOP.equals(property)) {
                    return this.templateContext.getTop();
                }
                if (PROPERTY_CONTEXT.equals(property)) {
                    return this.templateContext.getContext();
                }
                if (PROPERTY_MY.equals(property)) {
                    return this.templateContext.getMy();
                }
                return this.templateContext.getCur();
            }
            if (property instanceof String && (valueExp = context.getVariableMapper().resolveVariable((String)property)) != null) {
                context.setPropertyResolved(true);
                return valueExp.getValue(context);
            }
            Object cur = this.templateContext.getCur();
            if (cur != null) {
                Object value = context.getELResolver().getValue(context, cur, property);
                if (context.isPropertyResolved()) {
                    if (value != null) {
                        return value;
                    }
                    context.setPropertyResolved(false);
                }
            }
            if ((scope = this.templateContext.getMy()) != null && scope.containsKey(property)) {
                context.setPropertyResolved(true);
                return scope.get(property);
            }
            scope = this.templateContext.getTop();
            if (scope != null && scope.containsKey(property)) {
                context.setPropertyResolved(true);
                return scope.get(property);
            }
        }
        return null;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null && TOP_LEVEL_PROPERTIES.contains(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null && TOP_LEVEL_PROPERTIES.contains(property)) {
            throw new PropertyNotWritableException();
        }
    }
}

