/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationInfo;
import org.nuxeo.ecm.user.registration.actions.UserRegistrationActions;

@Name(value="bulkImportSocialWorkspaceActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class BulkImportSocialWorkspaceActions
extends UserRegistrationActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BulkImportSocialWorkspaceActions.class);
    @In(create=true)
    protected transient UserManager userManager;
    protected boolean doNotNotifyMembers = false;
    protected List<Map<String, String>> rightsMenuEntries = null;

    public boolean isDoNotNotifyMembers() {
        return this.doNotNotifyMembers;
    }

    public void setDoNotNotifyMembers(boolean doNotNotifyMembers) {
        this.doNotNotifyMembers = doNotNotifyMembers;
    }

    public List<Map<String, String>> getRightsMenuEntries() {
        if (this.rightsMenuEntries == null) {
            this.rightsMenuEntries = new ArrayList<Map<String, String>>();
            this.rightsMenuEntries.add(BulkImportSocialWorkspaceActions.buildEntry("label.social.workspace.member", "member"));
            this.rightsMenuEntries.add(BulkImportSocialWorkspaceActions.buildEntry("label.social.workspace.administrator", "administrator"));
        }
        return this.rightsMenuEntries;
    }

    protected static Map<String, String> buildEntry(String label, String value) {
        HashMap<String, String> entry = new HashMap<String, String>();
        entry.put("value", value);
        entry.put("label", label);
        return entry;
    }

    public void importUserFromListOfEmail() {
        throw new ClientRuntimeException("Deprecated");
    }

    public void importUserFromGroups() {
        throw new ClientRuntimeException("Deprecated");
    }

    protected Map<String, Serializable> getAdditionalsParameters() {
        Map additionalsParameters = super.getAdditionalsParameters();
        additionalsParameters.put("doNotNotifyMembers", this.doNotNotifyMembers);
        return additionalsParameters;
    }

    public void resetPojos() {
        super.resetPojos();
        this.doNotNotifyMembers = false;
    }

    protected void doSubmitUserRegistration(String configurationName) {
        if (StringUtils.isBlank((String)configurationName)) {
            configurationName = "social_collaboration";
        }
        try {
            this.userinfo.setPassword(RandomStringUtils.randomAlphanumeric((int)6));
            SocialWorkspace sw = SocialWorkspaceHelper.toSocialWorkspace((DocumentModel)this.navigationContext.getCurrentDocument());
            if (this.isInvitationPossible(sw, this.userinfo)) {
                boolean autoAccept = !StringUtils.isBlank((String)this.multipleEmails) || !sw.mustApproveSubscription();
                this.userRegistrationService.submitRegistrationRequest(configurationName, this.userinfo, this.docinfo, this.getAdditionalsParameters(), UserInvitationService.ValidationMethod.EMAIL, autoAccept, this.documentManager.getPrincipal().getName());
                this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("label.user.invited.success"), new Object[0]);
            }
        }
        catch (ClientException e) {
            log.info((Object)("Unable to register user: " + e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("label.unable.invite.user"), new Object[0]);
        }
    }

    protected boolean isInvitationPossible(SocialWorkspace sw, UserRegistrationInfo userInfo) {
        try {
            HashMap<String, String> filter = new HashMap<String, String>();
            String emailKey = this.userManager.getUserEmailField();
            filter.put(emailKey, userInfo.getEmail());
            HashSet<String> pattern = new HashSet<String>();
            pattern.add(emailKey);
            DocumentModelList users = this.userManager.searchUsers(filter, pattern);
            if (users.size() > 0) {
                userInfo.setLogin(((DocumentModel)users.get(0)).getId());
                NuxeoPrincipal nxp = this.userManager.getPrincipal(((DocumentModel)users.get(0)).getId());
                return sw.shouldRequestSubscription((Principal)nxp);
            }
            return StringUtils.isBlank((String)sw.getSubscriptionRequestStatus((Principal)new NuxeoPrincipalImpl(userInfo.getLogin())));
        }
        catch (ClientException e) {
            log.debug((Object)e, (Throwable)e);
            return true;
        }
    }
}

