/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message;

import java.io.Serializable;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.social.mini.message.MiniMessage;
import org.nuxeo.ecm.social.mini.message.MiniMessageService;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.runtime.api.Framework;

@Name(value="miniMessageActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class MiniMessageActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MINI_MESSAGE_CREATED_EVENT = "miniMessageCreated";
    @In(create=true)
    protected transient ContentViewActions contentViewActions;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(required=true, create=true)
    protected transient Principal currentUser;
    protected String newMessage;
    protected static final Log log = LogFactory.getLog(MiniMessageActions.class);

    public String getNewMessage() {
        return this.newMessage;
    }

    public void setNewMessage(String newMessage) {
        this.newMessage = newMessage;
    }

    public void createNewMiniMessage() {
        MiniMessageService miniMessageService = (MiniMessageService)Framework.getLocalService(MiniMessageService.class);
        miniMessageService.addMiniMessage(this.currentUser, this.newMessage);
        Events.instance().raiseEvent(MINI_MESSAGE_CREATED_EVENT, new Object[0]);
        this.newMessage = null;
    }

    public void deleteMiniMessage(MiniMessage miniMessage) {
        MiniMessageService miniMessageService = (MiniMessageService)Framework.getLocalService(MiniMessageService.class);
        miniMessageService.removeMiniMessage(miniMessage);
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("info.mini.message.deleted"), new Object[0]);
    }

    @Observer(value={"miniMessageCreated"})
    public void onMiniMessageCreated() {
        this.contentViewActions.refreshOnSeamEvent(MINI_MESSAGE_CREATED_EVENT);
        this.contentViewActions.resetPageProviderOnSeamEvent(MINI_MESSAGE_CREATED_EVENT);
    }
}

