/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.relationship.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipKindDescriptor;
import org.nuxeo.ecm.social.relationship.service.RelationshipKindRegistry;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class RelationshipServiceImpl
extends DefaultComponent
implements RelationshipService {
    public static final String KINDS_EXTENSION_POINT = "relationshipKinds";
    protected static final String RELATIONSHIP_DIRECTORY_NAME = "actorRelationshipDirectory";
    private static final Log log = LogFactory.getLog(RelationshipServiceImpl.class);
    protected RelationshipKindRegistry relationshipKindRegistry;

    public void activate(ComponentContext context) throws Exception {
        this.relationshipKindRegistry = new RelationshipKindRegistry();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.relationshipKindRegistry = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (KINDS_EXTENSION_POINT.equals(extensionPoint)) {
            this.relationshipKindRegistry.addContribution((RelationshipKindDescriptor)contribution);
        }
    }

    @Override
    public List<RelationshipKind> getRelationshipKinds(String actorId, String targetId) {
        HashMap<String, Serializable> filters = new HashMap<String, Serializable>();
        filters.put("actor", (Serializable)((Object)actorId));
        filters.put("target", (Serializable)((Object)targetId));
        Set<RelationshipKind> kinds = new HashSet<RelationshipKind>();
        for (DocumentModel relation : this.queryRelationshipsDirectory(filters, false)) {
            try {
                kinds.add(RelationshipServiceImpl.buildKindFromRelationshipModel(relation));
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        kinds = this.relationshipKindRegistry.filterUnregisteredRelationshipKinds(kinds);
        return new ArrayList<RelationshipKind>(kinds);
    }

    @Override
    public List<String> getTargetsOfKind(String actorId, RelationshipKind kind) {
        HashMap<String, Serializable> filters = new HashMap<String, Serializable>();
        filters.put("actor", (Serializable)((Object)actorId));
        if (kind != null && !kind.isEmpty()) {
            filters.put("kind", (Serializable)((Object)kind.toString()));
        }
        return RelationshipServiceImpl.buildListFromProperty(this.queryRelationshipsDirectory(filters, false), "actor_relationship", "target");
    }

    @Override
    public List<String> getTargets(String actorId) {
        return this.getTargetsOfKind(actorId, null);
    }

    @Override
    public List<String> getTargetsWithFulltext(String actorId, String targetPattern) {
        return this.getTargetsWithFulltext(actorId, null, targetPattern);
    }

    @Override
    public List<String> getTargetsWithFulltext(String actorId, RelationshipKind kind, String targetPattern) {
        HashMap<String, Serializable> filters = new HashMap<String, Serializable>();
        filters.put("actor", (Serializable)((Object)actorId));
        if (kind != null && !kind.isEmpty()) {
            filters.put("kind", (Serializable)((Object)kind.toString()));
        }
        if (!StringUtils.isBlank((String)targetPattern)) {
            filters.put("target", (Serializable)((Object)targetPattern));
        }
        return RelationshipServiceImpl.buildListFromProperty(this.queryRelationshipsDirectory(filters, true), "actor_relationship", "target");
    }

    @Override
    public List<RelationshipKind> getRegisteredKinds(String group) {
        Set<RelationshipKind> kinds = this.relationshipKindRegistry.getRegisteredKinds(group);
        if (kinds == null) {
            return Collections.emptyList();
        }
        return new ArrayList<RelationshipKind>(kinds);
    }

    @Override
    public Boolean addRelation(String actorId, String targetId, RelationshipKind kind) {
        if (kind == null) {
            throw new ClientRuntimeException("Type cannot be null");
        }
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        Session relationshipsDirectory = null;
        try {
            relationshipsDirectory = directoryService.open(RELATIONSHIP_DIRECTORY_NAME);
            HashMap<String, String> relationship = new HashMap<String, String>();
            relationship.put("actor", actorId);
            relationship.put("target", targetId);
            relationship.put("kind", kind.toString());
            DocumentModelList relationships = relationshipsDirectory.query(relationship);
            if (relationships.isEmpty()) {
                relationshipsDirectory.createEntry(new HashMap(relationship));
                Boolean bl = true;
                return bl;
            }
            Boolean bl = false;
            return bl;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException("Unable to create a new relation", (Throwable)e);
        }
        finally {
            if (relationshipsDirectory != null) {
                try {
                    relationshipsDirectory.close();
                }
                catch (DirectoryException e) {
                    log.error((Object)"Error while trying to close relationships directory");
                    log.debug((Object)"Exception occurred", (Throwable)e);
                }
            }
        }
    }

    @Override
    public Boolean removeRelation(String actorId, String targetId, RelationshipKind kind) {
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        Session relationshipDirectory = null;
        try {
            DocumentModelList relations;
            relationshipDirectory = directoryService.open(RELATIONSHIP_DIRECTORY_NAME);
            HashMap<String, String> filter = new HashMap<String, String>();
            filter.put("actor", actorId);
            if (!StringUtils.isBlank((String)targetId)) {
                filter.put("target", targetId);
            }
            if (kind != null && !kind.isEmpty()) {
                filter.put("kind", kind.toString());
            }
            if ((relations = relationshipDirectory.query(filter, filter.keySet())).isEmpty()) {
                log.warn((Object)"Trying to delete a relationship that doesn't exists");
                Boolean bl = false;
                return bl;
            }
            for (DocumentModel relation : relations) {
                relationshipDirectory.deleteEntry(relation.getId());
            }
            Boolean bl = true;
            return bl;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException("Unable to remove a relationship", (Throwable)e);
        }
        finally {
            if (relationshipDirectory != null) {
                try {
                    relationshipDirectory.close();
                }
                catch (DirectoryException e) {
                    log.error((Object)"Error while trying to close relationships directory");
                    log.debug((Object)"Exception occurred", (Throwable)e);
                }
            }
        }
    }

    protected DocumentModelList queryRelationshipsDirectory(Map<String, Serializable> filter, Boolean withFulltext) {
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        Session relationshipsDirectory = null;
        try {
            relationshipsDirectory = directoryService.open(RELATIONSHIP_DIRECTORY_NAME);
            HashSet<String> fulltextFields = new HashSet<String>();
            fulltextFields.add("kind");
            if (withFulltext.booleanValue()) {
                fulltextFields.addAll(filter.keySet());
            }
            DocumentModelList documentModelList = relationshipsDirectory.query(filter, fulltextFields, RelationshipServiceImpl.getRelationshipsOrderBy());
            return documentModelList;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException("Unable to query through relationships directory", (Throwable)e);
        }
        finally {
            if (relationshipsDirectory != null) {
                try {
                    relationshipsDirectory.close();
                }
                catch (DirectoryException e) {
                    log.error((Object)"Error while trying to close relationships directory");
                    log.debug((Object)"Exception occurred", (Throwable)e);
                }
            }
        }
    }

    protected static List<String> buildListFromProperty(DocumentModelList docs, String schema, String property) {
        HashSet<String> values = new HashSet<String>();
        for (DocumentModel doc : docs) {
            try {
                values.add(doc.getProperty(schema, property).toString());
            }
            catch (ClientException e) {
                log.debug((Object)("Property " + property + " is not accessible"));
            }
        }
        return new ArrayList<String>(values);
    }

    protected static RelationshipKind buildKindFromRelationshipModel(DocumentModel relation) throws ClientException {
        return RelationshipKind.fromString((String)((Object)relation.getPropertyValue("actor_relationship:kind")));
    }

    protected static Map<String, String> getRelationshipsOrderBy() {
        HashMap<String, String> order = new HashMap<String, String>();
        order.put("target", "desc");
        return order;
    }
}

