/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.adapters;

import java.io.Serializable;
import java.util.Calendar;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.social.workspace.adapters.Article;
import org.nuxeo.ecm.social.workspace.adapters.BaseAdapter;

public class ArticleAdapter
extends BaseAdapter
implements Article {
    public ArticleAdapter(DocumentModel doc) {
        super(doc);
    }

    @Override
    public String getAuthor() {
        return (String)ArticleAdapter.getDocProperty(this.doc, "dc:author");
    }

    @Override
    public Calendar getCreated() {
        return (Calendar)ArticleAdapter.getDocProperty(this.doc, "dc:created");
    }

    @Override
    public String getTitle() {
        return (String)ArticleAdapter.getDocProperty(this.doc, "dc:title");
    }

    @Override
    public String getContent() {
        return (String)ArticleAdapter.getDocProperty(this.doc, "note:note");
    }

    @Override
    public String getFirstNCharacters(int n) {
        String s = this.getContent();
        if (s != null) {
            int length = s.length();
            return s.substring(0, n < length ? n : length);
        }
        return "";
    }

    @Override
    public void setTitle(String text) {
        ArticleAdapter.setDocProperty(this.doc, "dc:title", (Serializable)((Object)text));
    }

    @Override
    public void setContent(String text) {
        ArticleAdapter.setDocProperty(this.doc, "note:note", (Serializable)((Object)text));
    }
}

