/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.registration;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.user.registration.RegistrationRules;
import org.nuxeo.ecm.user.registration.UserRegistrationConfiguration;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.runtime.api.Framework;

public class UserRegistrationListener
implements EventListener {
    protected static Log log = LogFactory.getLog(UserRegistrationListener.class);

    public void handleEvent(Event event) throws ClientException {
        if (!event.getName().equals("registrationValidated")) {
            return;
        }
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel registration = docCtx.getSourceDocument();
            try {
                UserRegistrationService userRegistrationService = (UserRegistrationService)Framework.getService(UserRegistrationService.class);
                UserRegistrationConfiguration config = userRegistrationService.getConfiguration(registration);
                RegistrationRules rules = userRegistrationService.getRegistrationRules(config.getName());
                if (rules.allowUserCreation()) {
                    NuxeoPrincipal principal = userRegistrationService.createUser(ctx.getCoreSession(), registration);
                    docCtx.setProperty("registeredUser", (Serializable)principal);
                }
                if (rules.allowUserCreation() || rules.isForcingRight()) {
                    userRegistrationService.addRightsOnDoc(ctx.getCoreSession(), registration);
                }
            }
            catch (Exception e) {
                event.markRollBack();
                throw new ClientException("Unable to complete registration", (Throwable)e);
            }
        }
    }
}

