/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class AddSocialDocumentFacetListener
implements EventListener {
    private static final List<String> validEventTypes = Arrays.asList("documentCreatedByCopy", "documentMoved", "aboutToCreate");

    public void handleEvent(Event event) throws ClientException {
        String eventName = event.getName();
        if (!validEventTypes.contains(eventName)) {
            return;
        }
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        List<String> allowedTypes = this.getSocialWorkspaceAllowedSubTypes();
        DocumentModel document = ((DocumentEventContext)ctx).getSourceDocument();
        if (document.hasFacet("Folderish") || !allowedTypes.contains(document.getType())) {
            return;
        }
        CoreSession session = ctx.getCoreSession();
        DocumentModel documentParent = session.getDocument(document.getParentRef());
        SocialWorkspace sws = AddSocialDocumentFacetListener.getSocialWorkspaceService().getSocialWorkspace(documentParent);
        if (sws == null) {
            return;
        }
        document.addFacet("SocialDocument");
        if ("documentMoved".equals(eventName)) {
            session.saveDocument(document);
        }
    }

    private List<String> getSocialWorkspaceAllowedSubTypes() {
        try {
            TypeManager typeManager = (TypeManager)Framework.getService(TypeManager.class);
            Collection allowedSubTypes = typeManager.findAllAllowedSubTypesFrom("SocialWorkspace");
            ArrayList<String> types = new ArrayList<String>();
            for (Type type : allowedSubTypes) {
                types.add(type.getId());
            }
            return types;
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private static SocialWorkspaceService getSocialWorkspaceService() {
        try {
            return (SocialWorkspaceService)Framework.getService(SocialWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

