/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.operations.services.PaginableDocumentModelListImpl;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;

@Operation(id="Social.Provider", category="Fetch", label="Social Provider", description="Social Provider")
public class SocialProviderOperation {
    public static final String ID = "Social.Provider";
    private static final Log log = LogFactory.getLog(SocialProviderOperation.class);
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService pps;
    @Context
    protected SocialWorkspaceService socialWorkspaceService;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Param(name="query", required=true)
    protected String query;
    @Param(name="language", required=false, widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="page", required=false)
    protected Integer page = 0;
    @Param(name="limit", required=false)
    protected Integer pageSize;
    @Param(name="sortInfo", required=false)
    protected StringList sortInfoAsStringList;
    @Param(name="contextPath", required=true)
    protected String contextPath;
    @Param(name="onlyPublicDocuments", required=false)
    protected String onlyPublicDocuments;
    @Param(name="queryParams", required=false)
    protected StringList strParameters;
    protected static final DocumentModelList EMPTY_LIST = new DocumentModelListImpl();

    @OperationMethod
    public DocumentModelList run() throws Exception {
        String principal = this.session.getPrincipal().getName();
        List<SortInfo> sortInfos = this.manageSortParameter();
        Object[] parameters = null;
        if (this.strParameters != null && !this.strParameters.isEmpty()) {
            parameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = principal;
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.session.getRepositoryName();
            }
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = new Long(this.pageSize.intValue());
        }
        if (StringUtils.isBlank((String)this.contextPath)) {
            return EMPTY_LIST;
        }
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(this.session, (DocumentRef)new PathRef(this.contextPath));
        if (socialWorkspace != null) {
            String finalPath = socialWorkspace.getDocument().getPathAsString();
            if (this.onlyPublicDocuments != null && Boolean.parseBoolean(this.onlyPublicDocuments)) {
                finalPath = socialWorkspace.getPublicSectionPath();
            }
            String s = " ecm:path STARTSWITH " + NXQLQueryBuilder.prepareStringLiteral((String)finalPath, (boolean)true, (boolean)true);
            if (this.query != null) {
                this.query = this.query.toUpperCase().contains("WHERE") ? this.query + " AND " + s : this.query + " WHERE " + s;
            }
        }
        CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
        desc.setPattern(this.query);
        return new PaginableDocumentModelListImpl(this.pps.getPageProvider(this.providerName, (PageProviderDefinition)desc, sortInfos, targetPageSize, new Long(this.page.intValue()), props, parameters));
    }

    protected List<SortInfo> manageSortParameter() {
        ArrayList<SortInfo> sortInfos = new ArrayList<SortInfo>();
        if (this.sortInfoAsStringList != null) {
            String sortParameterSeparator = " ";
            for (String sortInfoDesc : this.sortInfoAsStringList) {
                SortInfo sortInfo;
                if (sortInfoDesc.contains(sortParameterSeparator)) {
                    String[] parts = sortInfoDesc.split(sortParameterSeparator);
                    sortInfo = new SortInfo(parts[0], Boolean.parseBoolean(parts[1]));
                } else {
                    sortInfo = new SortInfo(sortInfoDesc, true);
                }
                sortInfos.add(sortInfo);
            }
        }
        return sortInfos;
    }
}

