/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.activity.ActivitiesList;
import org.nuxeo.ecm.activity.ActivitiesListImpl;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.activity.ActivityMessageLabelDescriptor;
import org.nuxeo.ecm.activity.ActivityStream;
import org.nuxeo.ecm.activity.ActivityStreamFilter;
import org.nuxeo.ecm.activity.ActivityStreamFilterDescriptor;
import org.nuxeo.ecm.activity.ActivityStreamRegistry;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ActivityStreamServiceImpl
extends DefaultComponent
implements ActivityStreamService {
    private static final Log log = LogFactory.getLog(ActivityStreamServiceImpl.class);
    public static final String ACTIVITIES_PROVIDER = "nxactivities";
    public static final String ACTIVITY_STREAM_FILTER_EP = "activityStreamFilters";
    public static final String ACTIVITY_MESSAGE_LABELS_EP = "activityMessageLabels";
    public static final String ACTIVITY_STREAMS_EP = "activityStreams";
    protected final ThreadLocal<EntityManager> localEntityManager = new ThreadLocal();
    protected final Map<String, ActivityStreamFilter> activityStreamFilters = new HashMap<String, ActivityStreamFilter>();
    protected final Map<String, String> activityMessageLabels = new HashMap<String, String>();
    protected ActivityStreamRegistry activityStreamRegistry;
    protected PersistenceProvider persistenceProvider;

    @Override
    public ActivitiesList query(String filterId, Map<String, Serializable> parameters) {
        return this.query(filterId, parameters, 0L, 0L);
    }

    @Override
    public ActivitiesList query(String filterId, Map<String, Serializable> parameters, long offset, long limit) {
        if ("allActivities".equals(filterId)) {
            return this.queryAll(offset, limit);
        }
        ActivityStreamFilter filter = this.activityStreamFilters.get(filterId);
        if (filter == null) {
            throw new ClientRuntimeException(String.format("Unable to retrieve '%s' ActivityStreamFilter", filterId));
        }
        return this.query(filter, parameters, offset, limit);
    }

    protected ActivitiesList query(final ActivityStreamFilter filter, final Map<String, Serializable> parameters, final long offset, final long limit) {
        try {
            return (ActivitiesList)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<ActivitiesList>(){

                public ActivitiesList runWith(EntityManager em) {
                    return ActivityStreamServiceImpl.this.query(em, filter, parameters, offset, limit);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ActivitiesList query(EntityManager em, ActivityStreamFilter filter, Map<String, Serializable> parameters, long offset, long limit) {
        try {
            this.localEntityManager.set(em);
            ActivitiesList activitiesList = filter.query(this, parameters, offset, limit);
            return activitiesList;
        }
        finally {
            this.localEntityManager.remove();
        }
    }

    protected ActivitiesList queryAll(final long offset, final long limit) {
        try {
            return (ActivitiesList)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<ActivitiesList>(){

                public ActivitiesList runWith(EntityManager em) {
                    return ActivityStreamServiceImpl.this.queryAll(em, offset, limit);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected ActivitiesList queryAll(EntityManager em, long offset, long limit) {
        Query query = em.createQuery("from Activity activity order by activity.id asc");
        if (limit > 0L) {
            query.setMaxResults((int)limit);
            if (offset > 0L) {
                query.setFirstResult((int)offset);
            }
        }
        return new ActivitiesListImpl(query.getResultList());
    }

    @Override
    public Activity addActivity(final Activity activity) {
        if (activity.getPublishedDate() == null) {
            activity.setPublishedDate(new Date());
        }
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    ActivityStreamServiceImpl.this.addActivity(em, activity);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addActivity(EntityManager em, Activity activity) {
        try {
            this.localEntityManager.set(em);
            em.persist((Object)activity);
            for (ActivityStreamFilter filter : this.activityStreamFilters.values()) {
                if (!filter.isInterestedIn(activity)) continue;
                filter.handleNewActivity(this, activity);
            }
        }
        finally {
            this.localEntityManager.remove();
        }
    }

    @Override
    public void removeActivities(final Collection<Serializable> activityIds) {
        if (activityIds == null || activityIds.isEmpty()) {
            return;
        }
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    ActivityStreamServiceImpl.this.removeActivities(em, activityIds);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeActivities(EntityManager em, Collection<Serializable> activityIds) {
        try {
            this.localEntityManager.set(em);
            for (ActivityStreamFilter filter : this.activityStreamFilters.values()) {
                filter.handleRemovedActivities(this, activityIds);
            }
            Query query = em.createQuery("delete from Activity activity where activity.id in (:ids)");
            query.setParameter("ids", activityIds);
            query.executeUpdate();
        }
        finally {
            this.localEntityManager.remove();
        }
    }

    @Override
    public ActivityMessage toActivityMessage(Activity activity, Locale locale) {
        String messageTemplate;
        Map<String, String> fields = activity.toMap();
        if (!this.activityMessageLabels.containsKey(activity.getVerb())) {
            return new ActivityMessage(activity, activity.toString());
        }
        String labelKey = this.activityMessageLabels.get(activity.getVerb());
        try {
            messageTemplate = I18NUtils.getMessageString((String)"messages", (String)labelKey, null, (Locale)locale);
        }
        catch (MissingResourceException e) {
            log.error((Object)e.getMessage());
            log.debug((Object)e, (Throwable)e);
            return new ActivityMessage(activity, labelKey);
        }
        Pattern pattern = Pattern.compile("\\$\\{(.*?)\\}");
        Matcher m = pattern.matcher(messageTemplate);
        while (m.find()) {
            String param = m.group().replaceAll("[\\|$\\|{\\}]", "");
            if (!fields.containsKey(param)) continue;
            String value = fields.get(param);
            String displayValue = fields.get("display" + StringUtils.capitalize((String)param));
            if (ActivityHelper.isDocument(value)) {
                value = ActivityHelper.getDocumentLink(value, displayValue);
            } else if (ActivityHelper.isUser(value)) {
                value = ActivityHelper.getUserProfileLink(value, displayValue);
            }
            messageTemplate = messageTemplate.replace(m.group(), value);
        }
        return new ActivityMessage(activity, messageTemplate);
    }

    @Override
    public ActivityStream getActivityStream(String name) {
        return this.activityStreamRegistry.get(name);
    }

    public EntityManager getEntityManager() {
        return this.localEntityManager.get();
    }

    public PersistenceProvider getOrCreatePersistenceProvider() {
        if (this.persistenceProvider == null) {
            this.activatePersistenceProvider();
        }
        return this.persistenceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activatePersistenceProvider() {
        Thread thread = Thread.currentThread();
        ClassLoader last = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(PersistenceProvider.class.getClassLoader());
            PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getLocalService(PersistenceProviderFactory.class);
            this.persistenceProvider = persistenceProviderFactory.newProvider(ACTIVITIES_PROVIDER);
            this.persistenceProvider.openPersistenceUnit();
        }
        finally {
            thread.setContextClassLoader(last);
        }
    }

    protected void deactivatePersistenceProvider() {
        if (this.persistenceProvider != null) {
            this.persistenceProvider.closePersistenceUnit();
            this.persistenceProvider = null;
        }
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.activityStreamRegistry = new ActivityStreamRegistry();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.deactivatePersistenceProvider();
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ACTIVITY_STREAM_FILTER_EP.equals(extensionPoint)) {
            this.registerActivityStreamFilter((ActivityStreamFilterDescriptor)contribution);
        } else if (ACTIVITY_MESSAGE_LABELS_EP.equals(extensionPoint)) {
            this.registerActivityMessageLabel((ActivityMessageLabelDescriptor)contribution);
        } else if (ACTIVITY_STREAMS_EP.equals(extensionPoint)) {
            this.registerActivityStream((ActivityStream)contribution);
        }
    }

    private void registerActivityStreamFilter(ActivityStreamFilterDescriptor descriptor) throws ClientException {
        ActivityStreamFilter filter = descriptor.getActivityStreamFilter();
        String filterId = filter.getId();
        boolean enabled = descriptor.isEnabled();
        if (this.activityStreamFilters.containsKey(filterId)) {
            log.info((Object)("Overriding activity stream filter with id " + filterId));
            if (!enabled) {
                this.activityStreamFilters.remove(filterId);
                log.info((Object)("Disabled activity stream filter with id " + filterId));
            }
        }
        if (enabled) {
            log.info((Object)("Registering activity stream filter with id " + filterId));
            this.activityStreamFilters.put(filterId, descriptor.getActivityStreamFilter());
        }
    }

    private void registerActivityMessageLabel(ActivityMessageLabelDescriptor descriptor) {
        String activityVerb = descriptor.getActivityVerb();
        if (this.activityMessageLabels.containsKey(activityVerb)) {
            log.info((Object)("Overriding activity message label for verb " + activityVerb));
        }
        log.info((Object)("Registering activity message label for verb" + activityVerb));
        this.activityMessageLabels.put(activityVerb, descriptor.getLabelKey());
    }

    private void registerActivityStream(ActivityStream activityStream) {
        log.info((Object)String.format("Registering activity stream '%s'", activityStream.getName()));
        this.activityStreamRegistry.addContribution(activityStream);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (ACTIVITY_STREAM_FILTER_EP.equals(extensionPoint)) {
            this.unregisterActivityStreamFilter((ActivityStreamFilterDescriptor)contribution);
        } else if (ACTIVITY_MESSAGE_LABELS_EP.equals(extensionPoint)) {
            this.unregisterActivityMessageLabel((ActivityMessageLabelDescriptor)contribution);
        } else if (ACTIVITY_STREAMS_EP.equals(extensionPoint)) {
            this.unregisterActivityStream((ActivityStream)contribution);
        }
    }

    private void unregisterActivityStreamFilter(ActivityStreamFilterDescriptor descriptor) throws ClientException {
        ActivityStreamFilter filter = descriptor.getActivityStreamFilter();
        String filterId = filter.getId();
        this.activityStreamFilters.remove(filterId);
        log.info((Object)("Unregistering activity stream filter with id " + filterId));
    }

    private void unregisterActivityMessageLabel(ActivityMessageLabelDescriptor descriptor) {
        String activityVerb = descriptor.getActivityVerb();
        this.activityMessageLabels.remove(activityVerb);
        log.info((Object)("Unregistering activity message label for verb " + activityVerb));
    }

    private void unregisterActivityStream(ActivityStream activityStream) {
        this.activityStreamRegistry.removeContribution(activityStream);
        log.info((Object)String.format("Unregistering activity stream '%s'", activityStream.getName()));
    }
}

