/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.List;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;

@Operation(id="SocialWorkspace.UserStatus", category="Execution Context", label="Get User Social Workspace Status", description="Return user status")
public class GetUserSocialWorkspaceStatus {
    public static final String ID = "SocialWorkspace.UserStatus";
    @Context
    protected CoreSession session;
    @Context
    protected SocialWorkspaceService socialWorkspaceService;
    @Context
    protected RelationshipService relationshipService;
    @Param(name="contextPath", required=true)
    protected String contextPath;

    @OperationMethod
    public Blob run() throws Exception {
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.session.getPrincipal();
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(this.session, (DocumentRef)new PathRef(this.contextPath));
        List targets = this.relationshipService.getTargetsOfKind(ActivityHelper.createDocumentActivityObject((String)socialWorkspace.getDocument().getRepositoryName(), (String)socialWorkspace.getId()), RelationshipKind.fromString((String)"socialworkspace:members"));
        if (targets.contains(ActivityHelper.createUserActivityObject((Principal)currentUser))) {
            return GetUserSocialWorkspaceStatus.buildResponse(socialWorkspace.getDocument(), Status.MEMBER);
        }
        if (socialWorkspace.isAdministratorOrMember(currentUser)) {
            return GetUserSocialWorkspaceStatus.buildResponse(socialWorkspace.getDocument(), Status.MEMBER);
        }
        if (socialWorkspace.isSubscriptionRequestPending((Principal)currentUser)) {
            return GetUserSocialWorkspaceStatus.buildResponse(socialWorkspace.getDocument(), Status.REQUEST_PENDING);
        }
        return GetUserSocialWorkspaceStatus.buildResponse(socialWorkspace.getDocument(), Status.NOT_MEMBER);
    }

    protected static Blob buildResponse(DocumentModel sws, Status status) throws ClientException, UnsupportedEncodingException {
        JSONObject obj = new JSONObject();
        obj.element("status", (Object)status);
        obj.element("title", (Object)sws.getPropertyValue("dc:title"));
        obj.element("description", (Object)sws.getPropertyValue("dc:description"));
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(obj.toString().getBytes("UTF-8")), "application/json");
    }

    static enum Status {
        NOT_MEMBER,
        REQUEST_PENDING,
        MEMBER;

    }
}

