/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.ecm.user.center.profile.UserProfileService;

@Operation(id="SocialWorkspace.Members", category="Execution Context", label="Social Workspace Members", description="return members of a social workspace")
public class GetSocialWorkspaceMembers {
    public static final String ID = "SocialWorkspace.Members";
    public static final String AVATAR_PROPERTY = "userprofile:avatar";
    @Context
    protected CoreSession session;
    @Context
    protected SocialWorkspaceService socialWorkspaceService;
    @Context
    protected UserProfileService userProfileService;
    @Context
    protected UserManager userManager;
    @Param(name="pageSize")
    protected int pageSize = 5;
    @Param(name="page")
    protected int page = 0;
    @Param(name="contextPath", required=true)
    protected String contextPath;
    @Param(name="pattern", required=true)
    protected String pattern;

    @OperationMethod
    public Blob run() throws Exception {
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(this.session, (DocumentRef)new PathRef(this.contextPath));
        List users = socialWorkspace.searchMembers(this.pattern);
        return this.buildResponse(users);
    }

    protected Blob buildResponse(List<String> users) throws UnsupportedEncodingException, ClientException {
        JSONObject result = new JSONObject();
        result.put((Object)"page", (Object)this.page);
        result.put((Object)"pageMax", (Object)Math.ceil((float)users.size() / (float)this.pageSize));
        int startIndex = this.page * this.pageSize;
        users = users.subList(this.page * this.pageSize, Math.min(startIndex + this.pageSize, users.size()));
        JSONArray array = new JSONArray();
        for (String user : users) {
            NuxeoPrincipal principal = this.userManager.getPrincipal(user);
            JSONObject o = new JSONObject();
            o.element("id", (Object)principal.getName());
            o.element("firstName", (Object)principal.getFirstName());
            o.element("lastName", (Object)principal.getLastName());
            o.element("profileURL", (Object)ActivityHelper.getUserProfileURL((String)principal.getName()));
            o.element("avatarURL", (Object)this.getAvatarURL((Principal)principal));
            array.add((Object)o);
        }
        result.put((Object)"users", (Object)array);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(result.toString().getBytes("UTF-8")), "application/json");
    }

    protected String getAvatarURL(Principal principal) throws ClientException {
        String url = VirtualHostHelper.getContextPathProperty() + "/icons/missing_avatar.png";
        DocumentModel userProfileDoc = this.userProfileService.getUserProfileDocument(principal.getName(), this.session);
        if (userProfileDoc == null) {
            return url;
        }
        if (userProfileDoc.getPropertyValue(AVATAR_PROPERTY) != null) {
            url = VirtualHostHelper.getContextPathProperty() + "/" + DocumentModelFunctions.fileUrl((String)"downloadFile", (DocumentModel)userProfileDoc, (String)AVATAR_PROPERTY, (String)"avatar");
        }
        return url;
    }
}

