/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.adapters.SubscriptionRequest;
import org.nuxeo.ecm.social.workspace.service.SubscriptionRequestHandler;
import org.nuxeo.runtime.api.Framework;

public class DefaultSubscriptionRequestHandler
implements SubscriptionRequestHandler {
    private static final Log log = LogFactory.getLog(DefaultSubscriptionRequestHandler.class);
    public static final String SUBSCRIPTION_REQUESTS_ROOT_NAME = "socialWorkspaceSubscriptionRequests";
    public static final String SUBSCRIPTION_REQUESTS_ROOT_TYPE = "HiddenFolder";
    public static final String SUBSCRIPTION_REQUEST_CREATED_EVENT = "subscriptionRequestCreated";
    public static final String SUBSCRIPTION_REQUEST_ACCEPTED_EVENT = "subscriptionRequestAccepted";
    public static final String SUBSCRIPTION_REQUEST_REJECTED_EVENT = "subscriptionRequestRejected";
    public static final String PRINCIPAL_NAME_PROPERTY = "principalName";
    private UserManager userManager;
    private EventService eventService;

    @Override
    public void handleSubscriptionRequestFor(final SocialWorkspace socialWorkspace, final Principal principal) {
        try {
            String repositoryName = socialWorkspace.getDocument().getRepositoryName();
            new UnrestrictedSessionRunner(repositoryName, principal.getName()){

                public void run() throws ClientException {
                    DefaultSubscriptionRequestHandler.this.handleSubscriptionRequestFor(this.session, socialWorkspace, principal);
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private void handleSubscriptionRequestFor(CoreSession session, SocialWorkspace socialWorkspace, Principal principal) throws ClientException {
        if (socialWorkspace.mustApproveSubscription()) {
            if (this.isSubscriptionRequestPending(socialWorkspace, principal)) {
                return;
            }
            String subscriptionRequestName = socialWorkspace.getId() + "-" + principal.getName();
            DocumentModel subscriptionRequestsRoot = DefaultSubscriptionRequestHandler.getSubscriptionRequestsRoot(session, socialWorkspace);
            DocumentModel request = session.createDocumentModel(subscriptionRequestsRoot.getPathAsString(), subscriptionRequestName, "SubscriptionRequest");
            request.setPropertyValue("req:username", (Serializable)((Object)principal.getName()));
            NuxeoPrincipal nuxeoPrincipal = (NuxeoPrincipal)principal;
            request.setPropertyValue("req:userEmail", (Serializable)((Object)nuxeoPrincipal.getEmail()));
            request.setPropertyValue("req:type", (Serializable)((Object)"joinRequest"));
            request.setPropertyValue("req:info", (Serializable)((Object)socialWorkspace.getId()));
            request = session.createDocument(request);
            session.save();
            DocumentEventContext ctx = new DocumentEventContext(session, null, request);
            this.getEventService().fireEvent(SUBSCRIPTION_REQUEST_CREATED_EVENT, (EventContext)ctx);
        } else if (socialWorkspace.addMember(principal)) {
            DocumentEventContext ctx = new DocumentEventContext(session, null, socialWorkspace.getDocument());
            ctx.setProperty(PRINCIPAL_NAME_PROPERTY, (Serializable)((Object)principal.getName()));
            this.getEventService().fireEvent(SUBSCRIPTION_REQUEST_ACCEPTED_EVENT, (EventContext)ctx);
        }
    }

    private static DocumentModel getSubscriptionRequestsRoot(CoreSession session, SocialWorkspace socialWorkspace) throws ClientException {
        String subscriptionRequestsRootPath = new Path(socialWorkspace.getPath()).append(SUBSCRIPTION_REQUESTS_ROOT_NAME).toString();
        PathRef subscriptionRequestsRootRef = new PathRef(subscriptionRequestsRootPath);
        if (session.exists((DocumentRef)subscriptionRequestsRootRef)) {
            return session.getDocument((DocumentRef)subscriptionRequestsRootRef);
        }
        DocumentModel subscriptionRequestsRoot = session.createDocumentModel(socialWorkspace.getPath(), SUBSCRIPTION_REQUESTS_ROOT_NAME, SUBSCRIPTION_REQUESTS_ROOT_TYPE);
        return session.createDocument(subscriptionRequestsRoot);
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return this.userManager;
    }

    @Override
    public boolean isSubscriptionRequestPending(final SocialWorkspace socialWorkspace, final Principal principal) {
        final ArrayList subscriptionRequests = new ArrayList();
        try {
            String repositoryName = socialWorkspace.getDocument().getRepositoryName();
            new UnrestrictedSessionRunner(repositoryName, principal.getName()){

                public void run() throws ClientException {
                    String queryTemplate = "SELECT * FROM SubscriptionRequest WHERE req:type = '%s' AND req:username = '%s' AND req:info = '%s'";
                    String query = String.format(queryTemplate, "joinRequest", principal.getName(), socialWorkspace.getId());
                    subscriptionRequests.addAll(this.session.query(query));
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return !subscriptionRequests.isEmpty();
    }

    @Override
    public void acceptSubscriptionRequest(final SocialWorkspace socialWorkspace, final SubscriptionRequest subscriptionRequest) {
        try {
            String repositoryName = subscriptionRequest.getDocument().getRepositoryName();
            new UnrestrictedSessionRunner(repositoryName){

                public void run() throws ClientException {
                    DefaultSubscriptionRequestHandler.this.acceptSubscriptionRequest(this.session, socialWorkspace, subscriptionRequest);
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private void acceptSubscriptionRequest(CoreSession session, SocialWorkspace socialWorkspace, SubscriptionRequest subscriptionRequest) throws ClientException {
        String principalName = subscriptionRequest.getUsername();
        if (socialWorkspace.addMember((Principal)this.getUserManager().getPrincipal(principalName))) {
            DocumentModel request = session.getDocument(subscriptionRequest.getDocument().getRef());
            request.followTransition("accept");
            session.saveDocument(request);
            session.save();
            DocumentEventContext ctx = new DocumentEventContext(session, null, socialWorkspace.getDocument());
            ctx.setProperty(PRINCIPAL_NAME_PROPERTY, (Serializable)((Object)principalName));
            this.getEventService().fireEvent(SUBSCRIPTION_REQUEST_ACCEPTED_EVENT, (EventContext)ctx);
        }
    }

    @Override
    public void rejectSubscriptionRequest(final SocialWorkspace socialWorkspace, final SubscriptionRequest subscriptionRequest) {
        try {
            String repositoryName = subscriptionRequest.getDocument().getRepositoryName();
            new UnrestrictedSessionRunner(repositoryName){

                public void run() throws ClientException {
                    DefaultSubscriptionRequestHandler.this.rejectSubscriptionRequest(this.session, socialWorkspace, subscriptionRequest);
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private void rejectSubscriptionRequest(CoreSession session, SocialWorkspace socialWorkspace, SubscriptionRequest subscriptionRequest) throws ClientException {
        String principalName = subscriptionRequest.getUsername();
        DocumentModel request = session.getDocument(subscriptionRequest.getDocument().getRef());
        request.followTransition("reject");
        session.saveDocument(request);
        session.save();
        DocumentEventContext ctx = new DocumentEventContext(session, null, socialWorkspace.getDocument());
        ctx.setProperty(PRINCIPAL_NAME_PROPERTY, (Serializable)((Object)principalName));
        this.getEventService().fireEvent(SUBSCRIPTION_REQUEST_REJECTED_EVENT, (EventContext)ctx);
    }

    private EventService getEventService() {
        if (this.eventService == null) {
            try {
                this.eventService = (EventService)Framework.getService(EventService.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return this.eventService;
    }
}

