/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceServiceImpl;
import org.nuxeo.runtime.api.Framework;

public class SocialWorkspaceMembersManagementListener
implements PostCommitEventListener {
    private static Log log = LogFactory.getLog(SocialWorkspaceMembersManagementListener.class);
    private static final String TEMPLATE_ADDED = "templates/memberNotification.ftl";

    public void handleEvent(EventBundle eventBundle) throws ClientException {
        HashMap<DocumentRef, List<Event>> socialDocuments = new HashMap<DocumentRef, List<Event>>();
        if (!eventBundle.containsEventName("newMembersAdded") && !eventBundle.containsEventName("newMembersRemoved")) {
            return;
        }
        for (Event event : eventBundle) {
            String eventName = event.getName();
            if (!"newMembersAdded".equals(eventName) && !"newMembersRemoved".equals(eventName)) continue;
            this.addDocumentContextToMap(socialDocuments, event);
        }
        for (Map.Entry<DocumentRef, List<Event>> entry : socialDocuments.entrySet()) {
            this.notifyForDocument(entry);
        }
    }

    public void addDocumentContextToMap(Map<DocumentRef, List<Event>> socialDocuments, Event event) {
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        DocumentRef docRef = docCtx.getSourceDocument().getRef();
        if (socialDocuments.containsKey(docRef)) {
            socialDocuments.get(docRef).add(event);
        } else {
            ArrayList<Event> docContextes = new ArrayList<Event>();
            docContextes.add(event);
            socialDocuments.put(docRef, docContextes);
        }
    }

    private void notifyForDocument(Map.Entry<DocumentRef, List<Event>> eventContexts) {
        ArrayList<Principal> addedMembers = new ArrayList<Principal>();
        ArrayList<Principal> removedMembers = new ArrayList<Principal>();
        for (Event event : eventContexts.getValue()) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            List principals = (List)((Object)docCtx.getProperty("socialWorkspacePrincipals"));
            if (event.getName().equals("newMembersAdded")) {
                addedMembers.addAll(principals);
                continue;
            }
            if (!event.getName().equals("newMembersRemoved")) continue;
            removedMembers.addAll(principals);
        }
        if (!addedMembers.isEmpty() || !removedMembers.isEmpty()) {
            DocumentEventContext context = (DocumentEventContext)eventContexts.getValue().get(0).getContext();
            this.notifyMembers(context, addedMembers, removedMembers);
        }
    }

    public void notifyMembers(DocumentEventContext docCtx, List<Principal> addedMembers, List<Principal> removedMembers) {
        SocialWorkspace sw = (SocialWorkspace)docCtx.getSourceDocument().getAdapter(SocialWorkspace.class);
        if (sw == null) {
            log.info((Object)"Event is handling a non social workspace document");
            return;
        }
        OperationContext ctx = new OperationContext(docCtx.getCoreSession());
        ctx.setInput((Object)docCtx.getSourceDocument());
        ctx.put("addedMembers", this.buildPrincipalsString(addedMembers));
        ctx.put("removedMembers", this.buildPrincipalsString(removedMembers));
        Expression from = Scripting.newExpression((String)"Env[\"mail.from\"]");
        addedMembers.addAll(removedMembers);
        StringList to = this.buildRecipientsList(sw, addedMembers);
        if (to.isEmpty()) {
            log.info((Object)("No recipients found for member notification in" + docCtx.getSourceDocument().getId()));
            return;
        }
        String subject = "Member Activity of " + sw.getTitle();
        String template = TEMPLATE_ADDED;
        String message = SocialWorkspaceMembersManagementListener.loadTemplate(template);
        try {
            OperationChain chain = new OperationChain("SendMail");
            chain.add("Notification.SendMail").set("from", (Object)from).set("to", (Object)to).set("HTML", (Object)true).set("subject", (Object)subject).set("message", (Object)message);
            ((AutomationService)Framework.getLocalService(AutomationService.class)).run(ctx, chain);
        }
        catch (Exception e) {
            log.error((Object)"Unable to notify about a member management.", (Throwable)e);
            log.debug((Object)e, (Throwable)e);
        }
    }

    private List<String> buildPrincipalsString(List<Principal> principals) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Principal principal : principals) {
            ret.add(Functions.principalFullName((NuxeoPrincipal)((NuxeoPrincipal)principal)));
        }
        Collections.sort(ret);
        return ret;
    }

    private StringList buildRecipientsList(SocialWorkspace socialWorkspace, List<Principal> principals) {
        HashSet<String> emails = new HashSet<String>();
        List<String> members = socialWorkspace.getMembers();
        for (Principal principal : principals) {
            members.remove(principal.getName());
        }
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        for (String username : members) {
            try {
                String email = userManager.getPrincipal(username).getEmail();
                if (StringUtils.isBlank((String)email)) continue;
                emails.add(email);
            }
            catch (ClientException e) {
                log.info((Object)String.format("Trying to fetch an unknown user: %s", username));
                log.debug((Object)e, (Throwable)e);
            }
        }
        return new StringList(emails);
    }

    private static String loadTemplate(String key) {
        InputStream io = SocialWorkspaceServiceImpl.class.getClassLoader().getResourceAsStream(key);
        if (io != null) {
            try {
                String string = FileUtils.read((InputStream)io);
                return string;
            }
            catch (IOException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            finally {
                try {
                    io.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

