/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.listeners;

import java.security.Principal;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class SocialWorkspaceActivityListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (!"documentCreated".equals(event.getName()) && !"documentModified".equals(event.getName())) {
            return;
        }
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentModel doc = ((DocumentEventContext)ctx).getSourceDocument();
        if (doc.hasFacet("HiddenInNavigation")) {
            return;
        }
        SocialWorkspace socialWorkspace = ((SocialWorkspaceService)Framework.getLocalService(SocialWorkspaceService.class)).getSocialWorkspace(doc);
        if (socialWorkspace != null) {
            this.addActivity(event, ctx.getPrincipal(), doc, socialWorkspace);
        }
    }

    private void addActivity(Event event, Principal principal, DocumentModel doc, SocialWorkspace socialWorkspace) {
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        Activity activity = new ActivityBuilder().verb(event.getName() + "InSocialWorkspace").actor(ActivityHelper.createUserActivityObject((Principal)principal)).displayActor(ActivityHelper.generateDisplayName((Principal)principal)).object(ActivityHelper.createDocumentActivityObject((DocumentModel)doc)).displayObject(ActivityHelper.getDocumentTitle((DocumentModel)doc)).target(ActivityHelper.createDocumentActivityObject((DocumentModel)socialWorkspace.getDocument())).displayTarget(socialWorkspace.getTitle()).build();
        activityStreamService.addActivity(activity);
    }
}

