/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.adapters;

import java.security.Principal;
import java.util.List;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.social.workspace.adapters.BaseAdapter;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.adapters.SubscriptionRequest;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class SocialWorkspaceAdapter
extends BaseAdapter
implements SocialWorkspace {
    private static final String MEMBER_NOTIFICATION_DISABLED = "memberNotificationDisabled";

    public SocialWorkspaceAdapter(DocumentModel doc) {
        super(doc);
    }

    @Override
    public String getId() {
        return this.doc.getId();
    }

    @Override
    public String getTitle() {
        try {
            return this.doc.getTitle();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getPath() {
        return this.doc.getPathAsString();
    }

    @Override
    public boolean isPublic() {
        Boolean isPublic = (Boolean)SocialWorkspaceAdapter.getDocProperty(this.doc, "socialw:isPublic");
        return isPublic == null ? false : isPublic;
    }

    @Override
    public boolean isPrivate() {
        return !this.isPublic();
    }

    @Override
    public void makePublic() {
        SocialWorkspaceAdapter.getSocialWorkspaceService().makeSocialWorkspacePublic(this);
    }

    @Override
    public void makePrivate() {
        SocialWorkspaceAdapter.getSocialWorkspaceService().makeSocialWorkspacePrivate(this);
    }

    @Override
    public boolean mustApproveSubscription() {
        Boolean approveSubscription = (Boolean)SocialWorkspaceAdapter.getDocProperty(this.doc, "socialw:approveSubscription");
        return approveSubscription == null ? false : approveSubscription;
    }

    @Override
    public boolean isMembersNotificationEnabled() {
        Boolean membersNotificationDisabled = (Boolean)this.doc.getContextData(ScopeType.REQUEST, MEMBER_NOTIFICATION_DISABLED);
        return membersNotificationDisabled == null ? true : membersNotificationDisabled == false;
    }

    @Override
    public boolean addAdministrator(Principal principal) {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().addSocialWorkspaceAdministrator(this, principal);
    }

    @Override
    public boolean addMember(Principal principal) {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().addSocialWorkspaceMember(this, principal);
    }

    @Override
    public void removeAdministrator(Principal principal) {
        SocialWorkspaceAdapter.getSocialWorkspaceService().removeSocialWorkspaceAdministrator(this, principal);
    }

    @Override
    public void removeMember(Principal principal) {
        SocialWorkspaceAdapter.getSocialWorkspaceService().removeSocialWorkspaceMember(this, principal);
    }

    @Override
    public boolean isAdministrator(NuxeoPrincipal principal) {
        return principal.isMemberOf(this.getAdministratorsGroupName());
    }

    @Override
    public boolean isMember(NuxeoPrincipal principal) {
        return principal.isMemberOf(this.getMembersGroupName());
    }

    @Override
    public boolean isAdministratorOrMember(NuxeoPrincipal principal) {
        return this.isAdministrator(principal) || this.isMember(principal);
    }

    @Override
    public List<String> searchMembers(String pattern) {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().searchMembers(this, pattern);
    }

    @Override
    public List<String> searchAdministrators(String pattern) {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().searchAdministrators(this, pattern);
    }

    @Override
    public List<String> searchUsers(String pattern) {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().searchUsers(this, null, pattern);
    }

    @Override
    public List<String> getMembers() {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().searchUsers(this, SocialWorkspaceHelper.buildRelationMemberKind(), null);
    }

    @Override
    public List<String> getAdministrators() {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().searchUsers(this, SocialWorkspaceHelper.buildRelationAdministratorKind(), null);
    }

    @Override
    public List<String> getUsers() {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().searchUsers(this, null, null);
    }

    @Override
    public String getAdministratorsGroupName() {
        return SocialWorkspaceHelper.getSocialWorkspaceAdministratorsGroupName(this.doc);
    }

    @Override
    public String getAdministratorsGroupLabel() {
        try {
            return SocialWorkspaceHelper.getSocialWorkspaceAdministratorsGroupLabel(this.doc.getTitle());
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getMembersGroupName() {
        return SocialWorkspaceHelper.getSocialWorkspaceMembersGroupName(this.doc);
    }

    @Override
    public String getMembersGroupLabel() {
        try {
            return SocialWorkspaceHelper.getSocialWorkspaceMembersGroupLabel(this.doc.getTitle());
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getPublicSectionPath() {
        return SocialWorkspaceHelper.getPublicSectionPath(this.doc);
    }

    @Override
    public String getPrivateSectionPath() {
        return SocialWorkspaceHelper.getPrivateSectionPath(this.doc);
    }

    @Override
    public String getNewsItemsRootPath() {
        return SocialWorkspaceHelper.getNewsItemsRootPath(this.doc);
    }

    @Override
    public String getDashboardSpacesRootPath() {
        return this.doc.getPath().append("social").toString();
    }

    @Override
    public String getPublicDashboardSpacePath() {
        return new Path(this.getDashboardSpacesRootPath()).append("publicDashboardSpace").toString();
    }

    @Override
    public String getPrivateDashboardSpacePath() {
        return new Path(this.getDashboardSpacesRootPath()).append("privateDashboardSpace").toString();
    }

    @Override
    public void handleSubscriptionRequest(Principal principal) {
        SocialWorkspaceAdapter.getSocialWorkspaceService().handleSubscriptionRequest(this, principal);
    }

    @Override
    public boolean isSubscriptionRequestPending(Principal principal) {
        return SocialWorkspaceAdapter.getSocialWorkspaceService().isSubscriptionRequestPending(this, principal);
    }

    @Override
    public void acceptSubscriptionRequest(SubscriptionRequest subscriptionRequest) {
        SocialWorkspaceAdapter.getSocialWorkspaceService().acceptSubscriptionRequest(this, subscriptionRequest);
    }

    @Override
    public void rejectSubscriptionRequest(SubscriptionRequest subscriptionRequest) {
        SocialWorkspaceAdapter.getSocialWorkspaceService().rejectSubscriptionRequest(this, subscriptionRequest);
    }

    @Override
    public DocumentModel getDocument() {
        return this.doc;
    }

    @Override
    public void setDocument(DocumentModel doc) {
        if (!this.doc.getId().equals(doc.getId())) {
            throw new ClientRuntimeException("");
        }
        this.doc = doc;
    }

    private static SocialWorkspaceService getSocialWorkspaceService() {
        try {
            return (SocialWorkspaceService)Framework.getService(SocialWorkspaceService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

