/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.contentview.seam.ContentViewActions;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.adapters.SubscriptionRequest;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="socialWorkspaceSubscriptionRequestActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class SocialWorkspaceSubscriptionRequestActions
implements Serializable {
    public static final String SUBSCRIPTION_REQUESTS_UPDATED = "subscriptionRequestsUpdated";
    private static final long serialVersionUID = -7362146679190186610L;
    private static final Log log = LogFactory.getLog(SocialWorkspaceSubscriptionRequestActions.class);
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true)
    protected transient ContentViewActions contentViewActions;

    public void accept() throws ClientException {
        List list = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        this.processSelectedSubscriptionRequests(list, true);
    }

    public void reject() throws ClientException {
        List list = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        this.processSelectedSubscriptionRequests(list, false);
    }

    protected void processSelectedSubscriptionRequests(List<DocumentModel> list, boolean accept) throws ClientException {
        SocialWorkspace socialWorkspace = SocialWorkspaceHelper.toSocialWorkspace((DocumentModel)this.navigationContext.getCurrentDocument());
        for (DocumentModel doc : list) {
            if (!"SubscriptionRequest".equals(doc.getType())) continue;
            SubscriptionRequest subscriptionRequest = (SubscriptionRequest)doc.getAdapter(SubscriptionRequest.class);
            SocialWorkspaceSubscriptionRequestActions.processSubscriptionRequest(socialWorkspace, subscriptionRequest, accept);
        }
        this.documentManager.save();
        Events.instance().raiseEvent(SUBSCRIPTION_REQUESTS_UPDATED, new Object[0]);
    }

    protected static void processSubscriptionRequest(SocialWorkspace socialWorkspace, SubscriptionRequest subscriptionRequest, boolean accept) {
        try {
            if (accept) {
                socialWorkspace.acceptSubscriptionRequest(subscriptionRequest);
            } else {
                socialWorkspace.rejectSubscriptionRequest(subscriptionRequest);
            }
        }
        catch (Exception e) {
            log.warn((Object)String.format("Unable to process request for %s: %s", subscriptionRequest.getDocument(), e.getMessage()));
            log.debug((Object)e, (Throwable)e);
        }
    }

    public boolean enableRequestActions() throws ClientException {
        List list = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (list.isEmpty()) {
            return false;
        }
        for (DocumentModel doc : list) {
            if ("pending".equals(doc.getCurrentLifeCycleState())) continue;
            return false;
        }
        return true;
    }

    @Observer(value={"subscriptionRequestsUpdated"})
    public void onSubscriptionRequestsUpdated() {
        this.contentViewActions.refreshOnSeamEvent(SUBSCRIPTION_REQUESTS_UPDATED);
        this.contentViewActions.resetPageProviderOnSeamEvent(SUBSCRIPTION_REQUESTS_UPDATED);
    }

    public boolean enableSocialWorkspaceActions() throws ClientException {
        List list = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (list.isEmpty()) {
            return false;
        }
        for (DocumentModel doc : list) {
            if ("project".equals(doc.getCurrentLifeCycleState())) continue;
            return false;
        }
        return true;
    }

    public void acceptSocialWorkspaces() throws ClientException {
        List list = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        this.processSocialWorkspaces(list, "approve");
    }

    public void rejectSocialWorkspaces() throws ClientException {
        List list = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        this.processSocialWorkspaces(list, "delete");
        Events.instance().raiseEvent("documentChanged", new Object[0]);
    }

    protected void processSocialWorkspaces(List<DocumentModel> list, String transition) throws ClientException {
        for (DocumentModel doc : list) {
            try {
                if (!"SocialWorkspace".equals(doc.getType())) continue;
                doc.followTransition(transition);
                this.removeValidationTasks(doc);
            }
            catch (Exception e) {
                log.debug((Object)("failed to process the social workspace ... " + doc.getId()), (Throwable)e);
            }
        }
        this.documentManager.save();
    }

    private void removeValidationTasks(DocumentModel doc) {
        ArrayList<Task> canceledTasks = new ArrayList<Task>();
        try {
            TaskService taskService = (TaskService)Framework.getService(TaskService.class);
            List taskInstances = taskService.getTaskInstances(doc, (NuxeoPrincipal)null, this.documentManager);
            for (Task task : taskInstances) {
                if (!"validateSocialWorkspace".equals(task.getName())) continue;
                task.cancel(this.documentManager);
                canceledTasks.add(task);
            }
            if (!canceledTasks.isEmpty()) {
                DocumentModel[] docToSave = new DocumentModel[canceledTasks.size()];
                canceledTasks.toArray(docToSave);
                this.documentManager.saveDocuments(docToSave);
            }
        }
        catch (Exception e) {
            log.warn((Object)"failed cancel tasks for accepted/rejected SocialWorkspace", (Throwable)e);
        }
    }
}

