/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.social.mini.message.MiniMessage;
import org.nuxeo.ecm.social.mini.message.MiniMessageHelper;

@Operation(id="Services.GetMiniMessages", category="Services", label="Get mini messages", description="Get mini messages for the current user.")
public class GetMiniMessages {
    public static final String ID = "Services.GetMiniMessages";
    public static final String PROVIDER_NAME = "gadget_mini_messages";
    public static final String CIRCLE_KIND = "circle";
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService pageProviderService;
    @Param(name="actor", required=false)
    protected String actor;
    @Param(name="relationshipKind", required=false)
    protected String relationshipKind;
    @Param(name="miniMessagesStreamType", required=false)
    protected String miniMessagesStreamType;
    @Param(name="language", required=false)
    protected String language;
    @Param(name="offset", required=false)
    protected Integer offset;
    @Param(name="limit", required=false)
    protected Integer limit;

    @OperationMethod
    public Blob run() throws Exception {
        if (StringUtils.isBlank((String)this.relationshipKind)) {
            this.relationshipKind = CIRCLE_KIND;
        }
        if (StringUtils.isBlank((String)this.actor)) {
            this.actor = this.session.getPrincipal().getName();
        }
        if (StringUtils.isBlank((String)this.miniMessagesStreamType)) {
            this.miniMessagesStreamType = "forActor";
        }
        Long targetOffset = 0L;
        if (this.offset != null) {
            targetOffset = this.offset.longValue();
        }
        Long targetLimit = null;
        if (this.limit != null) {
            targetLimit = this.limit.longValue();
        }
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("streamType", this.miniMessagesStreamType);
        props.put("actor", this.actor);
        props.put("relationshipKind", this.relationshipKind);
        PageProvider pageProvider = this.pageProviderService.getPageProvider(PROVIDER_NAME, null, targetLimit, Long.valueOf(0L), props, new Object[0]);
        pageProvider.setCurrentPageOffset(targetOffset.longValue());
        String json = MiniMessageHelper.toJSON((PageProvider<MiniMessage>)pageProvider, locale, this.session);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(json.getBytes("UTF-8")), "application/json");
    }
}

