/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.mini.message.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.mini.message.MiniMessage;
import org.nuxeo.ecm.social.mini.message.MiniMessageService;

@Operation(id="Services.AddMiniMessage", category="Services", label="Add a mini message", description="Add a mini message.")
public class AddMiniMessage {
    public static final String ID = "Services.AddMiniMessage";
    @Context
    protected CoreSession session;
    @Context
    protected MiniMessageService miniMessageService;
    @Context
    protected UserManager userManager;
    @Param(name="language", required=false)
    protected String language;
    @Param(name="message")
    protected String message;
    @Param(name="publishedDate", required=false)
    protected Date publishedDate;
    @Param(name="contextPath", required=false)
    protected String contextPath;

    @OperationMethod
    public Blob run() throws Exception {
        MiniMessage miniMessage;
        NuxeoPrincipal principal;
        if (this.publishedDate == null) {
            this.publishedDate = new Date();
        }
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        DateFormat dateFormat = DateFormat.getDateInstance(2, locale);
        String target = null;
        if (this.contextPath != null) {
            TargetActivityObject targetActivityObject = new TargetActivityObject(this.session, this.contextPath);
            targetActivityObject.runUnrestricted();
            if (targetActivityObject.documentActivityObject != null) {
                target = targetActivityObject.documentActivityObject;
            }
        }
        String fullName = (principal = this.userManager.getPrincipal((miniMessage = this.miniMessageService.addMiniMessage(this.session.getPrincipal(), this.message, this.publishedDate, target)).getActor())) == null ? "" : principal.getFirstName() + " " + principal.getLastName();
        HashMap<String, Object> o = new HashMap<String, Object>();
        o.put("id", miniMessage.getId());
        o.put("actor", miniMessage.getActor());
        o.put("fullName", fullName);
        o.put("message", miniMessage.getMessage());
        o.put("publishedDate", dateFormat.format(miniMessage.getPublishedDate()));
        o.put("isCurrentUserMiniMessage", this.session.getPrincipal().getName().equals(miniMessage.getActor()));
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, o);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), "application/json");
    }

    private static class TargetActivityObject
    extends UnrestrictedSessionRunner {
        private String contextPath;
        public String documentActivityObject;

        public TargetActivityObject(CoreSession session, String contextPath) {
            super(session);
            this.contextPath = contextPath;
        }

        public void run() throws ClientException {
            PathRef docRef = new PathRef(this.contextPath);
            if (this.session.exists((DocumentRef)docRef)) {
                DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
                this.documentActivityObject = ActivityHelper.createDocumentActivityObject((DocumentModel)doc);
            }
        }
    }
}

