/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.showcase.content;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.URLBlob;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;
import org.nuxeo.ecm.showcase.content.ShowcaseContentImporter;
import org.nuxeo.runtime.api.Framework;

public class InitListener
implements PostContentCreationHandler {
    private static final Log log = LogFactory.getLog(InitListener.class);
    private static final String SHOWCASE_CONTENT = "showcase_content.zip";

    public void execute(CoreSession session) {
        if (Framework.isTestModeSet()) {
            return;
        }
        try {
            URL url = this.getClass().getClassLoader().getResource(SHOWCASE_CONTENT);
            if (url == null) {
                throw new IOException("Unable to found showcase_content.zip resource.");
            }
            URLBlob blob = new URLBlob(url);
            new ShowcaseContentImporter(session).create((Blob)blob);
            log.info((Object)"Showcase content imported.");
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

