/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.usermapper.extension;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.Script;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.usermapper.extension.AbstractUserMapper;

public class GroovyUserMapper
extends AbstractUserMapper {
    protected final String mapperSource;
    protected final String wrapperSource;
    protected GroovyClassLoader loader;
    protected Class<?> mapperClass;
    protected Class<?> wrapperClass;

    public GroovyUserMapper(String mapperScript, String wrapperScript) {
        this.mapperSource = mapperScript;
        this.wrapperSource = wrapperScript;
    }

    @Override
    public void init(Map<String, String> params) {
        this.loader = new GroovyClassLoader(this.getClass().getClassLoader());
        this.mapperClass = this.loader.parseClass(this.mapperSource);
        if (!StringUtils.isEmpty((CharSequence)this.wrapperSource)) {
            this.wrapperClass = this.loader.parseClass(this.wrapperSource);
        }
    }

    @Override
    protected void resolveAttributes(Object userObject, Map<String, Serializable> searchAttributes, Map<String, Serializable> userAttributes, Map<String, Serializable> profileAttributes) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("searchAttributes", searchAttributes);
        context.put("profileAttributes", profileAttributes);
        context.put("userAttributes", userAttributes);
        context.put("userObject", userObject);
        Binding binding = new Binding(context);
        Script script = InvokerHelper.createScript(this.mapperClass, (Binding)binding);
        script.run();
    }

    @Override
    public Object wrapNuxeoPrincipal(NuxeoPrincipal principal, Object userObject, Map<String, Serializable> params) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("nuxeoPrincipal", principal);
        context.put("userObject", userObject);
        context.put("params", params);
        Binding binding = new Binding(context);
        Script script = InvokerHelper.createScript(this.wrapperClass, (Binding)binding);
        script.run();
        return context.get("userObject");
    }

    @Override
    public void release() {
        this.loader.clearCache();
        try {
            this.loader.close();
        }
        catch (IOException e) {
            log.error((Object)"Error during Groovy cleanup", (Throwable)e);
        }
    }
}

