/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.shibboleth.invitation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.user.invite.AlreadyProcessedRegistrationException;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationException;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.Template;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/shibboInvite")
@WebObject(type="shibboInvite")
@Produces(value={"text/html;charset=UTF-8"})
public class ShibboInviteObject
extends ModuleRoot {
    private static final Log log = LogFactory.getLog(ShibboInviteObject.class);

    @POST
    @Path(value="validate")
    public Object validateTrialForm(@FormParam(value="isShibbo") boolean isShibbo) {
        Map registrationData;
        UserInvitationService usr = this.fetchService();
        FormData formData = this.getContext().getForm();
        String requestId = formData.getString("RequestId");
        String password = formData.getString("Password");
        String passwordConfirmation = formData.getString("PasswordConfirmation");
        try {
            usr.checkRequestId(requestId);
        }
        catch (AlreadyProcessedRegistrationException ape) {
            return this.getView("ValidationErrorTemplate").arg("exceptionMsg", (Object)this.ctx.getMessage("label.error.requestAlreadyProcessed"));
        }
        catch (UserRegistrationException ue) {
            return this.getView("ValidationErrorTemplate").arg("exceptionMsg", (Object)this.ctx.getMessage("label.error.requestNotExisting", new Object[]{requestId}));
        }
        if (!isShibbo) {
            if (password == null || "".equals(password.trim())) {
                return this.redisplayFormWithErrorMessage("EnterPassword", this.ctx.getMessage("label.registerForm.validation.password"), formData);
            }
            if (passwordConfirmation == null || "".equals(passwordConfirmation.trim()) && !isShibbo) {
                return this.redisplayFormWithErrorMessage("EnterPassword", this.ctx.getMessage("label.registerForm.validation.passwordconfirmation"), formData);
            }
            if (!(password = password.trim()).equals(passwordConfirmation = passwordConfirmation.trim()) && !isShibbo) {
                return this.redisplayFormWithErrorMessage("EnterPassword", this.ctx.getMessage("label.registerForm.validation.passwordvalidation"), formData);
            }
        }
        try {
            Map<String, Serializable> additionalInfo = this.buildAdditionalInfos();
            additionalInfo.put("invitationPassword", (Serializable)((Object)password));
            registrationData = usr.validateRegistration(requestId, additionalInfo);
        }
        catch (AlreadyProcessedRegistrationException ape) {
            log.info((Object)"Try to validate an already processed registration");
            return this.getView("ValidationErrorTemplate").arg("exceptionMsg", (Object)this.ctx.getMessage("label.error.requestAlreadyProcessed"));
        }
        catch (UserRegistrationException ue) {
            log.warn((Object)"Unable to validate registration request", (Throwable)ue);
            return this.getView("ValidationErrorTemplate").arg("exceptionMsg", (Object)this.ctx.getMessage("label.errror.requestNotAccepted"));
        }
        String webappName = VirtualHostHelper.getWebAppName((ServletRequest)this.getContext().getRequest());
        String redirectUrl = "/" + webappName + "/";
        if (!isShibbo) {
            redirectUrl = redirectUrl + "logout";
        }
        return this.getView("UserCreated").arg("redirectUrl", (Object)redirectUrl).arg("data", (Object)registrationData).arg("isShibbo", (Object)isShibbo);
    }

    protected UserInvitationService fetchService() {
        return (UserInvitationService)Framework.getService(UserRegistrationService.class);
    }

    @GET
    @Path(value="enterpassword/{configurationName}/{requestId}")
    public Object validatePasswordForm(@PathParam(value="requestId") String requestId, @PathParam(value="configurationName") String configurationName) {
        UserInvitationService usr = this.fetchService();
        try {
            usr.checkRequestId(requestId);
        }
        catch (AlreadyProcessedRegistrationException ape) {
            return this.getView("ValidationErrorTemplate").arg("exceptionMsg", (Object)this.ctx.getMessage("label.error.requestAlreadyProcessed"));
        }
        catch (UserRegistrationException ue) {
            return this.getView("ValidationErrorTemplate").arg("exceptionMsg", (Object)this.ctx.getMessage("label.error.requestNotExisting", new Object[]{requestId}));
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("RequestId", requestId);
        data.put("ConfigurationName", configurationName);
        String webappName = VirtualHostHelper.getWebAppName((ServletRequest)this.getContext().getRequest());
        String validationRelUrl = usr.getConfiguration(configurationName).getValidationRelUrl();
        String valUrl = "/" + webappName + "/" + validationRelUrl;
        data.put("ValidationUrl", valUrl);
        return this.getView("EnterPassword").arg("data", data);
    }

    protected Map<String, Serializable> buildAdditionalInfos() {
        return new HashMap<String, Serializable>();
    }

    protected Template redisplayFormWithMessage(String messageType, String formName, String message, FormData data) {
        HashMap<String, String> savedData = new HashMap<String, String>();
        for (String key : data.getKeys()) {
            savedData.put(key, data.getString(key));
        }
        return this.getView(formName).arg("data", savedData).arg(messageType, (Object)message);
    }

    protected Template redisplayFormWithInfoMessage(String formName, String message, FormData data) {
        return this.redisplayFormWithMessage("info", formName, message, data);
    }

    protected Template redisplayFormWithErrorMessage(String formName, String message, FormData data) {
        return this.redisplayFormWithMessage("err", formName, message, data);
    }
}

