/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.log.internals;

import org.nuxeo.lib.stream.log.LogOffset;
import org.nuxeo.lib.stream.log.LogPartition;

public class LogOffsetImpl
implements LogOffset {
    protected final LogPartition partition;
    protected final long offset;

    public LogOffsetImpl(LogPartition partition, long offset) {
        this.partition = partition;
        this.offset = offset;
    }

    public LogOffsetImpl(String name, int partition, long offset) {
        this.partition = LogPartition.of(name, partition);
        this.offset = offset;
    }

    @Override
    public LogPartition partition() {
        return this.partition;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    public String toString() {
        return String.format("%s:+%d", this.partition, this.offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogOffsetImpl offsetImpl = (LogOffsetImpl)o;
        return this.partition.equals(offsetImpl.partition) && this.offset == offsetImpl.offset;
    }

    public int hashCode() {
        int result = this.partition != null ? this.partition.hashCode() : 0;
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        return result;
    }

    @Override
    public int compareTo(LogOffset o) {
        if (this == o) {
            return 0;
        }
        if (o == null || this.getClass() != o.getClass()) {
            throw new IllegalArgumentException("Cannot compare offsets with different classes");
        }
        LogOffsetImpl offsetImpl = (LogOffsetImpl)o;
        if (this.partition.equals(offsetImpl.partition)) {
            throw new IllegalArgumentException("Cannot compare offsets from different partitions");
        }
        return Long.compare(this.offset, offsetImpl.offset);
    }
}

