/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.lib.stream.tools;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.lib.stream.log.chronicle.ChronicleLogManager;
import org.nuxeo.lib.stream.tools.CommandRegistry;
import org.nuxeo.lib.stream.tools.command.Command;

public class Main {
    protected final Map<String, Command> commandMap = new HashMap<String, Command>();
    protected final Options options = new Options();
    protected String command;
    protected LogManager manager;

    public static void main(String[] args) throws InterruptedException {
        new Main().run(args);
    }

    public void run(String[] args) {
        Path path = Paths.get(args[0], new String[0]);
        this.manager = new ChronicleLogManager(path);
        this.command = args[1];
        this.runWithArgs(Arrays.copyOfRange(args, 2, args.length));
    }

    protected void runWithArgs(String[] args) {
        Command cmd = this.getCommand();
        cmd.updateOptions(this.options);
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmdLine = parser.parse(this.options, args);
            cmd.run(this.manager, cmdLine);
        }
        catch (ParseException e) {
            this.helpAndExit("Parse error: " + e.getMessage());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.helpAndExit("Interrupted: " + e.getMessage());
        }
    }

    protected Command getCommand() {
        if (this.commandMap.isEmpty()) {
            new CommandRegistry().commands().forEach(cmd -> this.commandMap.put(cmd.name(), (Command)cmd));
        }
        if (!this.commandMap.containsKey(this.command)) {
            this.helpAndExit("Unknown command: " + this.command);
        }
        return this.commandMap.get(this.command);
    }

    protected void helpAndExit(String message) {
        System.err.println(message);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.command != null ? this.command : "tools", this.options);
        System.exit(-1);
    }
}

