/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.shibboleth.invitation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.shibboleth.invitation.ShibbolethUserInfo;
import org.nuxeo.usermapper.extension.UserMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShibbolethUserMapper
implements UserMapper {
    private static final Logger log = LoggerFactory.getLogger(ShibbolethUserMapper.class);
    public static final String DEFAULT_REGISTRATION = "default_registration";
    protected static String userSchemaName = "user";
    protected static String groupSchemaName = "group";
    protected UserManager userManager;

    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(Object userObject) {
        return this.getOrCreateAndUpdateNuxeoPrincipal(userObject, true, true, null);
    }

    protected UserInvitationService fetchService() {
        return (UserInvitationService)Framework.getLocalService(UserRegistrationService.class);
    }

    public NuxeoPrincipal getOrCreateAndUpdateNuxeoPrincipal(Object userObject, boolean createIfNeeded, boolean update, Map<String, Serializable> params) {
        ShibbolethUserInfo userInfo = new ShibbolethUserInfo((String)((Map)userObject).get("username"), (String)((Map)userObject).get("password"), (String)((Map)userObject).get("firstName"), (String)((Map)userObject).get("lastName"), (String)((Map)userObject).get("company"));
        DocumentModel userDoc = null;
        String mail = (String)((Map)userObject).get("email");
        String userName = userInfo.getUserName();
        if (mail != null && !mail.isEmpty()) {
            userDoc = this.findUser(mail);
        }
        if (userDoc != null) {
            DocumentModelList targetDocs = this.getTargetDocuments(mail);
            for (final DocumentModel targetDoc : targetDocs) {
                for (final ACL acl : targetDoc.getACP().getACLs()) {
                    for (final ACE oldACE : acl.getACEs()) {
                        if (!oldACE.getUsername().equals(mail)) continue;
                        final ACE newACE = ACE.builder((String)userName, (String)oldACE.getPermission()).creator(oldACE.getCreator()).begin(oldACE.getBegin()).end(oldACE.getEnd()).build();
                        new UnrestrictedSessionRunner(this.getTargetRepositoryName()){

                            public void run() {
                                this.session.replaceACE(targetDoc.getRef(), acl.getName(), oldACE, newACE);
                            }
                        }.runUnrestricted();
                    }
                }
            }
        } else {
            userDoc = this.findUser(userInfo.getUserName());
        }
        if (userDoc == null) {
            userDoc = this.createUser(userInfo);
        }
        userDoc = this.updateUser(userDoc, userInfo);
        String userId = (String)((Object)userDoc.getPropertyValue(this.userManager.getUserIdField()));
        return this.userManager.getPrincipal(userId);
    }

    protected DocumentModel createUser(ShibbolethUserInfo userInfo) {
        DocumentModel userDoc;
        try {
            userDoc = this.userManager.getBareUserModel();
            userDoc.setPropertyValue(this.userManager.getUserIdField(), (Serializable)((Object)userInfo.getUserName()));
            userDoc.setPropertyValue(this.userManager.getUserEmailField(), (Serializable)((Object)userInfo.getUserName()));
            this.userManager.createUser(userDoc);
        }
        catch (NuxeoException e) {
            String message = "Error while creating user [" + userInfo.getUserName() + "] in UserManager";
            log.error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return userDoc;
    }

    protected DocumentModelList getTargetDocuments(final String userId) {
        final UserInvitationService userInvitationService = (UserInvitationService)Framework.getLocalService(UserRegistrationService.class);
        DocumentModelListImpl registrationDocs = new DocumentModelListImpl();
        new UnrestrictedSessionRunner(this.getTargetRepositoryName(), (DocumentModelList)registrationDocs){
            final /* synthetic */ DocumentModelList val$registrationDocs;
            {
                this.val$registrationDocs = documentModelList;
                super(x0);
            }

            public void run() {
                String query = "SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'validated' AND ecm:mixinType = '" + userInvitationService.getConfiguration(ShibbolethUserMapper.DEFAULT_REGISTRATION).getRequestDocType() + "' AND" + userInvitationService.getConfiguration(ShibbolethUserMapper.DEFAULT_REGISTRATION).getUserInfoUsernameField() + " = '%s' AND ecm:isCheckedInVersion = 0";
                query = String.format(query, userId);
                this.val$registrationDocs.addAll((Collection)this.session.query(query));
            }
        }.runUnrestricted();
        return registrationDocs;
    }

    public void init(Map<String, String> params) throws Exception {
        this.userManager = (UserManager)Framework.getLocalService(UserManager.class);
        userSchemaName = this.userManager.getUserSchemaName();
        groupSchemaName = this.userManager.getGroupSchemaName();
    }

    private DocumentModel findUser(String userName) {
        HashMap<String, String> query = new HashMap<String, String>();
        query.put(this.userManager.getUserIdField(), userName);
        DocumentModelList users = this.userManager.searchUsers(query, null);
        if (users.isEmpty()) {
            return null;
        }
        return (DocumentModel)users.get(0);
    }

    private DocumentModel updateUser(DocumentModel userDoc, ShibbolethUserInfo userInfo) {
        userDoc.setPropertyValue(this.userManager.getUserIdField(), (Serializable)((Object)userInfo.getUserName()));
        userDoc.setPropertyValue(this.userManager.getUserEmailField(), (Serializable)((Object)userInfo.getUserName()));
        userDoc.setProperty(userSchemaName, "firstName", (Object)userInfo.getFirstName());
        userDoc.setProperty(userSchemaName, "lastName", (Object)userInfo.getLastName());
        userDoc.setProperty(userSchemaName, "password", (Object)userInfo.getPassword());
        userDoc.setProperty(userSchemaName, "company", (Object)userInfo.getCompany());
        this.userManager.updateUser(userDoc);
        return userDoc;
    }

    public Object wrapNuxeoPrincipal(NuxeoPrincipal principal, Object nativePrincipal, Map<String, Serializable> params) {
        throw new UnsupportedOperationException();
    }

    public void release() {
    }

    public String getTargetRepositoryName() {
        return ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepositoryName();
    }
}

