/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.richfaces.validator.ObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateValidator
extends ObjectValidator {
    private Map<ObjectValidator.ValidatorKey, ClassValidator<? extends Object>> classValidators = new ConcurrentHashMap<ObjectValidator.ValidatorKey, ClassValidator<? extends Object>>();

    HibernateValidator() {
        ClassValidator.class.getName();
    }

    @Override
    public String[] validateGraph(FacesContext context, Object value, Set<String> profiles) {
        InvalidValue[] invalidValues;
        ClassValidator<? extends Object> validator;
        if (null == context) {
            throw new FacesException("Input parameters is not correct.");
        }
        String[] validationMessages = null;
        if (null != value && (validator = this.getValidator(value.getClass(), this.calculateLocale(context))).hasValidationRules() && null != (invalidValues = validator.getInvalidValues(value)) && invalidValues.length > 0) {
            validationMessages = new String[invalidValues.length];
            for (int i = 0; i < invalidValues.length; ++i) {
                InvalidValue invalidValue = invalidValues[i];
                validationMessages[i] = invalidValue.getMessage();
            }
        }
        return validationMessages;
    }

    protected InvalidValue[] validateClass(Class<? extends Object> beanClass, String property, Object value, Locale locale) {
        ClassValidator<? extends Object> classValidator = this.getValidator(beanClass, locale);
        InvalidValue[] invalidValues = classValidator.getPotentialInvalidValues(property, value);
        return invalidValues;
    }

    protected ClassValidator<? extends Object> getValidator(Class<? extends Object> beanClass, Locale locale) {
        ObjectValidator.ValidatorKey key = new ObjectValidator.ValidatorKey(beanClass, locale);
        ClassValidator<? extends Object> result = this.classValidators.get(key);
        if (null == result) {
            result = this.createValidator(beanClass, locale);
            this.classValidators.put(key, result);
        }
        return result;
    }

    protected ClassValidator<? extends Object> createValidator(Class<? extends Object> beanClass, Locale locale) {
        ResourceBundle bundle = this.getCurrentResourceBundle(locale);
        return bundle == null ? new ClassValidator(beanClass) : new ClassValidator(beanClass, bundle);
    }

    @Override
    protected String[] validate(Object base, String property, Object value, Locale locale, Set<String> profiles) {
        InvalidValue[] invalidValues = this.validateBean(base, property, value, locale);
        if (null == invalidValues) {
            return null;
        }
        String[] result = new String[invalidValues.length];
        for (int i = 0; i < invalidValues.length; ++i) {
            InvalidValue invalidValue = invalidValues[i];
            result[i] = invalidValue.getMessage();
        }
        return result;
    }

    protected InvalidValue[] validateBean(Object base, String property, Object value, Locale locale) {
        Class<?> beanClass = base.getClass();
        InvalidValue[] invalidValues = this.validateClass(beanClass, property, value, locale);
        return invalidValues;
    }
}

