/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSEncoder;
import org.richfaces.component.UIDragIndicator;
import org.richfaces.component.nsutils.NSUtils;
import org.richfaces.renderkit.DnDParametersEncoder;
import org.richfaces.renderkit.TemplateEncoderRendererBase;

public class DragIndicatorRendererBase
extends TemplateEncoderRendererBase {
    public static final String ACCEPT_CLASS = "acceptClass";
    public static final String REJECT_CLASS = "rejectClass";
    public static final String ACCEPT = "accept";
    public static final String DEFAULT = "default";
    public static final String REJECT = "reject";
    protected static final Collection MARKERS_PREDEFINED = new ArrayList(3);
    public static final String SINGLE = "single";
    public static final String MULTI = "multi";
    protected static final Collection FACETS_PREDEFINED;

    protected Class getComponentClass() {
        return UIDragIndicator.class;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    protected boolean notHasFacet(UIComponent component, Object facetName) {
        return component.getFacet((String)facetName) == null;
    }

    protected String getPredefinedMarker(FacesContext context, Object facetName) {
        if (MARKERS_PREDEFINED.contains(facetName)) {
            StringBuffer buff = new StringBuffer();
            JSEncoder encoder = new JSEncoder();
            String source = "<img alt=\"\" border=\"0\" width=\"16\" height=\"16\" src=\"" + this.getResource("/org/richfaces/renderkit/html/images/" + facetName + ".gif").getUri(context, null) + "\" />";
            char[] chars = source.toString().toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char c = chars[i];
                if (!encoder.compile(c)) {
                    buff.append(encoder.encode(c));
                    continue;
                }
                buff.append(c);
            }
            return buff.toString();
        }
        throw new IllegalArgumentException("No predefined marker with [" + facetName + "] name exists!");
    }

    public void encodeChildScripts(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter responseWriter = context.getResponseWriter();
        for (String markerName : MARKERS_PREDEFINED) {
            responseWriter.write("elt.markers['" + markerName + "'] = \"");
            responseWriter.write(this.getPredefinedMarker(context, markerName));
            responseWriter.write("\";\n");
        }
        for (String facetName : FACETS_PREDEFINED) {
            UIComponent facet = component.getFacet(facetName);
            responseWriter.write("elt.indicatorTemplates['" + facetName + "'] = ");
            if (facet != null && facet.isRendered()) {
                this.writeScriptBody(context, facet, false);
                responseWriter.write(";\n");
                continue;
            }
            responseWriter.write(" DefaultDragIndicatorView;");
        }
    }

    public void encodeNamespace(FacesContext context, UIDragIndicator component) throws IOException {
        NSUtils.writeNameSpace((FacesContext)context, (UIComponent)component);
    }

    public void encodeDnDParams(FacesContext context, UIDragIndicator component) throws IOException {
        DnDParametersEncoder.getInstance().doEncode(context, (UIComponent)component);
    }

    static {
        MARKERS_PREDEFINED.add(ACCEPT);
        MARKERS_PREDEFINED.add(DEFAULT);
        MARKERS_PREDEFINED.add(REJECT);
        FACETS_PREDEFINED = new ArrayList(2);
        FACETS_PREDEFINED.add(SINGLE);
        FACETS_PREDEFINED.add(MULTI);
    }
}

