/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.listener;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamListener;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class CheckInStreamListener
extends ActivityStreamListener {
    private Log log = LogFactory.getLog(CheckInStreamListener.class);

    protected List<String> getHandledEventsName() {
        return Arrays.asList("documentCheckedIn");
    }

    protected String getDocumentTitle(CoreSession session, DocumentRef docRef) {
        try {
            DocumentModel doc = session.getDocument(docRef);
            return this.getDocumentTitle(doc);
        }
        catch (ClientException e) {
            this.log.debug((Object)e);
            return docRef.toString();
        }
    }

    protected String getDocumentTitle(DocumentModel doc) {
        String title = ActivityHelper.getDocumentTitle((DocumentModel)doc);
        if (doc.isVersionable()) {
            return String.format("%s (%s)", title, doc.getVersionLabel());
        }
        return title;
    }

    protected Activity toActivity(DocumentEventContext docEventContext, Event event, String context) {
        Principal principal = docEventContext.getPrincipal();
        DocumentModel doc = docEventContext.getSourceDocument();
        return new ActivityBuilder().actor(ActivityHelper.createUserActivityObject((Principal)principal)).displayActor(ActivityHelper.generateDisplayName((Principal)principal)).verb(event.getName()).object(ActivityHelper.createDocumentActivityObject((DocumentModel)doc)).displayObject(this.getDocumentTitle(doc)).target(ActivityHelper.createDocumentActivityObject((String)doc.getRepositoryName(), (String)doc.getParentRef().toString())).displayTarget(this.getDocumentTitle(docEventContext.getCoreSession(), doc.getParentRef())).context(context).build();
    }
}

