/*
 * Decompiled with CFR 0.152.
 */
package eu.scenari.jaxrs.webengine;

import eu.scenari.jaxrs.utils.SAXModifier;
import eu.scenari.jaxrs.utils.ZipExploder;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.relations.api.Literal;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.RelationManager;
import org.nuxeo.ecm.platform.relations.api.Resource;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.RelationDate;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;
import org.nuxeo.ecm.platform.relations.api.util.RelationConstants;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.ecm.webengine.model.ResourceType;
import org.nuxeo.ecm.webengine.model.WebContext;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;
import org.orioai.esupecm.nuxeo2xml.service.OriOaiNuxeo2XmlService;
import org.orioai.esupecm.workflow.service.OriOaiWorkflowService;

public class ImportScreenObject
extends DefaultObject {
    private static final Log log = LogFactory.getLog(ImportScreenObject.class);
    final CoreSession session;
    final DocumentModel doc;
    final String QUERY_FIND_SCAR = "SELECT * FROM Document WHERE dc:title ILIKE '%s' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
    final String QUERY_WORKSPACES = "SELECT * FROM Workspace WHERE ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";

    public ImportScreenObject(WebContext ctx, String repository, String docRef) throws ClientException {
        ResourceType resType = ctx.getModule().getType("ScenariRoot");
        this.initialize(ctx, resType, new Object[0]);
        this.session = this.getContext().getCoreSession();
        this.doc = this.session.getDocument((DocumentRef)new IdRef(docRef));
    }

    protected static DocumentViewCodecManager getCodecManager() {
        return (DocumentViewCodecManager)Framework.getLocalService(DocumentViewCodecManager.class);
    }

    protected ZipExploder getZipExplorer() throws ClientException, IOException {
        return new ZipExploder((Blob)this.doc.getPropertyValue("file:content"));
    }

    protected DocumentModelList filterOnPermission(DocumentModelList docs, String permission) throws ClientException {
        DocumentModelListImpl filtered = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (!this.session.hasPermission(doc.getRef(), permission)) continue;
            filtered.add((Object)doc);
        }
        return filtered.size() == 0 ? null : filtered;
    }

    protected DocumentModelList getWritableWorkspaces() throws ClientException {
        DocumentModelList workspaces = this.session.query("SELECT * FROM Workspace WHERE ecm:isProxy = 0 AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
        return this.filterOnPermission(workspaces, "ReadWrite");
    }

    protected DocumentModelList findSameArchivedScars() throws ClientException {
        try {
            Blob blob = this.getZipExplorer().findScar();
            if (blob == null || StringUtils.isBlank((String)blob.getFilename())) {
                return null;
            }
            DocumentModelList docs = this.doc.getCoreSession().query(String.format("SELECT * FROM Document WHERE dc:title ILIKE '%s' AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'", ZipExploder.prepareScarFilename(blob.getFilename())));
            return this.filterOnPermission(docs, "ReadWrite");
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
    }

    @GET
    @Produces(value={"text/html;charset=utf-8"})
    public Object getImportScreen() throws ClientException, IOException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("workspaces", this.getWritableWorkspaces());
        args.put("sameScars", this.findSameArchivedScars());
        OriOaiWorkflowService oaiWorkflowService = (OriOaiWorkflowService)Framework.getLocalService(OriOaiWorkflowService.class);
        String username = this.session.getPrincipal().getName();
        args.put("metadataTypes", oaiWorkflowService.getMetadataTypes(username));
        return this.getView("import_screen").args(args);
    }

    @POST
    public Object getExplodeZipScreen(@FormParam(value="workspaceRef") String workspaceRef, @FormParam(value="scarRef") String scarRef, @FormParam(value="workflowActionId") String wkfActionId, @FormParam(value="publish") String publish) throws ClientException, URISyntaxException, IOException {
        if (StringUtils.isBlank((String)(workspaceRef + scarRef))) {
            log.error((Object)"Trying to confirm scar archive without any parameters.");
            return Response.notModified().build();
        }
        DocumentModel newDoc = !StringUtils.isBlank((String)scarRef) ? this.updateExistingScar(scarRef) : this.createDocumentModel(workspaceRef);
        String docUrl = ImportScreenObject.getCodecManager().getUrlFromDocumentView((DocumentView)new DocumentViewImpl(newDoc), true, VirtualHostHelper.getBaseURL((ServletRequest)this.ctx.getRequest()));
        if (!StringUtils.isBlank((String)wkfActionId)) {
            Map<String, Long> wkfIds = this.initWorkflowsPerBlob(newDoc, (BlobHolder)newDoc.getAdapter(BlobHolder.class), wkfActionId);
            this.processWorkflow((BlobHolder)this.doc.getAdapter(BlobHolder.class), wkfActionId, wkfIds);
        }
        return this.redirect(docUrl);
    }

    protected void processWorkflow(BlobHolder bh, String wkfActionId, Map<String, Long> wkfIds) throws ClientException {
        OriOaiWorkflowService service = (OriOaiWorkflowService)Framework.getLocalService(OriOaiWorkflowService.class);
        for (Blob blob : bh.getBlobs()) {
            Long wkfId = wkfIds.get(blob.getFilename());
            if (wkfId == null) continue;
            String idp = service.getIdp(this.getUsername(), wkfId);
            service.performAction(this.getUsername(), idp, Integer.parseInt(wkfActionId), "");
        }
    }

    protected Map<String, Long> initWorkflowsPerBlob(DocumentModel doc, BlobHolder bh, String wkfActionId) throws ClientException {
        OriOaiWorkflowService service = (OriOaiWorkflowService)Framework.getLocalService(OriOaiWorkflowService.class);
        HashMap<String, Long> ids = new HashMap<String, Long>();
        ArrayList<Statement> statements = new ArrayList<Statement>();
        for (Blob blob : bh.getBlobs()) {
            if (blob.getFilename() == null || blob.getFilename().endsWith("xml")) continue;
            Long wkfId = service.newWorkflowInstance(this.getUsername(), wkfActionId);
            ids.put(blob.getFilename(), wkfId);
            this.registerRelation(statements, doc, wkfId);
            String idp = service.getIdp(this.getUsername(), wkfId);
            String xmlWF = service.getXMLForms(this.getUsername(), idp);
            String xmlContent = this.buildXmlFromLomFile(doc.getId(), bh, blob.getFilename());
            SAXModifier modifier = new SAXModifier(xmlWF, xmlContent);
            modifier.moveNode("//lom:general/lom:identifier");
            modifier.moveNode("//lom:metaMetadata", true);
            modifier.moveNodes("//lom:contribute");
            modifier.moveChildren("//lom:educational");
            modifier.moveNode("//lom:classification");
            service.saveXML(this.getUsername(), idp, modifier.buildTargetAsXml());
        }
        ((RelationManager)Framework.getLocalService(RelationManager.class)).getGraph("default", this.session).add(statements);
        return ids;
    }

    protected void registerRelation(List<Statement> statements, DocumentModel doc, Long wkfId) throws ClientException {
        RelationManager relationManager = (RelationManager)Framework.getLocalService(RelationManager.class);
        Resource subject = relationManager.getResource("http://www.nuxeo.org/document/uid/", (Serializable)doc, null);
        ResourceImpl predicate = new ResourceImpl("http://purl.org/dc/terms/References");
        LiteralImpl object = new LiteralImpl(wkfId.toString());
        StatementImpl e = new StatementImpl((Node)subject, (Node)predicate, (Node)object);
        Literal now = RelationDate.getLiteralDate((Date)new Date());
        e.addProperty(RelationConstants.CREATION_DATE, (Node)now);
        e.addProperty(RelationConstants.MODIFICATION_DATE, (Node)now);
        statements.add((Statement)e);
    }

    private String buildXmlFromLomFile(String docId, BlobHolder bh, String filename) throws ClientException {
        String lom = FileUtils.getFileNameNoExt((String)filename) + "_lom.xml";
        for (Blob blob : bh.getBlobs()) {
            if (blob.getFilename() == null || !blob.getFilename().contains(lom)) continue;
            StringWriter sw = new StringWriter();
            try {
                IOUtils.copy((Reader)blob.getReader(), (Writer)sw);
                return this.replaceLink(docId, sw.toString(), filename);
            }
            catch (IOException ignored) {
            }
        }
        return "";
    }

    protected String replaceLink(String docId, String xml, String filename) throws ClientException {
        OriOaiNuxeo2XmlService serv = (OriOaiNuxeo2XmlService)Framework.getLocalService(OriOaiNuxeo2XmlService.class);
        String lomEntry = "<lom:entry>%s</lom:entry>";
        String lomLocation = "<lom:location>%s</lom:location>";
        xml = ImportScreenObject.replacePattern(xml, lomEntry, serv.getLastVersionUrl() + docId + "/file/$1");
        xml = ImportScreenObject.replacePattern(xml, lomLocation, serv.getLastVersionUrl() + docId + "/file/$1");
        return xml;
    }

    protected static String replacePattern(String text, String sourceFormat, String destinationURL) {
        String regex = String.format(sourceFormat, "\\W*(\\S+)\\W*");
        text = text.replaceAll(regex, String.format(sourceFormat, destinationURL));
        regex = String.format(sourceFormat, "\\W*(\\S+(?:zip))\\W*");
        return text.replaceAll(regex, String.format(sourceFormat, "$1/preview"));
    }

    private Map<Long, String> initIdps(Collection<Long> wfIds) {
        OriOaiWorkflowService oaiWorkflowService = (OriOaiWorkflowService)Framework.getLocalService(OriOaiWorkflowService.class);
        HashMap<Long, String> idps = new HashMap<Long, String>();
        for (Long id : wfIds) {
            idps.put(id, oaiWorkflowService.getIdp(this.getUsername(), id));
        }
        return idps;
    }

    protected DocumentModel updateExistingScar(String scarRef) throws ClientException, IOException {
        DocumentModel oldScar = this.session.getDocument((DocumentRef)new IdRef(scarRef));
        if (oldScar == null) {
            throw new ClientException("Try to update a non existing Scar archive.");
        }
        ZipExploder zipExplorer = this.getZipExplorer();
        if (!oldScar.getTitle().equals(ZipExploder.prepareScarFilename(zipExplorer.findScar().getFilename()))) {
            throw new ClientException("Trying to update another document.");
        }
        if (oldScar.isCheckedOut()) {
            this.session.checkIn(oldScar.getRef(), VersioningOption.MINOR, "Automatic versionning before updating SCAR.");
        }
        DocumentModel updatedDoc = zipExplorer.updateDocumentModel(this.doc, oldScar);
        updatedDoc.putContextData("VersioningOption", (Serializable)VersioningOption.MAJOR);
        return this.session.getLastDocumentVersion(this.session.saveDocument(updatedDoc).getRef());
    }

    protected DocumentModel createDocumentModel(String workspaceRef) throws ClientException, IOException {
        DocumentModel workspace = this.session.getDocument((DocumentRef)new IdRef(workspaceRef));
        ZipExploder ze = this.getZipExplorer();
        DocumentModel newDoc = this.session.createDocument(ze.createDocumentModel(this.doc, workspace));
        DocumentRef versionRef = this.session.checkIn(newDoc.getRef(), VersioningOption.MAJOR, null);
        this.session.removeDocument(this.doc.getRef());
        return this.session.getDocument(versionRef);
    }

    private String getUsername() {
        return this.session.getPrincipal().getName();
    }
}

