/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.project.sample.restAPI;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class LastBookRestlet
extends BaseNuxeoRestlet {
    private static final Log log = LogFactory.getLog(LastBookRestlet.class);
    public static final String LAST_BOOK_PROVIDER = "LAST_BOOK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request req, Response res) {
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        CoreSession session = this.getCoreSession(req, res);
        try {
            PageProviderService pps = (PageProviderService)Framework.getService(PageProviderService.class);
            PageProviderDefinition ppd = pps.getPageProviderDefinition(LAST_BOOK_PROVIDER);
            HashMap<String, Serializable> props = new HashMap<String, Serializable>();
            props.put("coreSession", (Serializable)session);
            PageProvider provider = pps.getPageProvider(LAST_BOOK_PROVIDER, ppd, null, null, Long.valueOf(1L), Long.valueOf(0L), props, new Object[0]);
            List dms = provider.getCurrentPage();
            if (dms.size() == 0) {
                LastBookRestlet.handleError((DOMDocument)result, (Response)res, (String)"No result available");
                return;
            }
            DocumentModel lastBookDm = (DocumentModel)dms.get(0);
            String json = this.serialize(lastBookDm);
            res.setEntity(json, MediaType.TEXT_PLAIN);
        }
        catch (Exception e) {
            LastBookRestlet.handleError((Response)res, (Exception)e);
        }
        finally {
            try {
                Repository.close((CoreSession)session);
            }
            catch (Exception e) {
                log.error((Object)"Repository close failed", (Throwable)e);
            }
        }
    }

    private String serialize(DocumentModel lastBookDm) throws PropertyException, ClientException {
        String jSonString = "{\"book\": {\"title\": \"" + lastBookDm.getPropertyValue("dc:title") + "\"," + "\"isbn\": \"" + lastBookDm.getPropertyValue("bk:isbn") + "\"," + "\"rating\": \"" + lastBookDm.getPropertyValue("bk:rating") + "\"," + "\"publicationDate\": \"" + lastBookDm.getPropertyValue("bk:publicationDate") + "\"," + "\"keywords\": \"" + lastBookDm.getPropertyValue("bk:keywords") + "\"}}";
        return jSonString;
    }

    private CoreSession getCoreSession(Request req, Response res) {
        CoreSession session;
        try {
            Repository repository = ((RepositoryManager)Framework.getService(RepositoryManager.class)).getDefaultRepository();
            if (repository == null) {
                throw new ClientException("Cannot get default repository");
            }
            HashMap<String, Serializable> context = new HashMap<String, Serializable>();
            context.put("principal", LastBookRestlet.getSerializablePrincipal((Request)req));
            session = repository.open(context);
        }
        catch (Exception e) {
            LastBookRestlet.handleError((Response)res, (Exception)e);
            return null;
        }
        return session;
    }
}

