/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.blob;

import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLBlob;
import org.nuxeo.ecm.platform.web.common.ServletHelper;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.forms.FormData;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;

@WebObject(type="blob")
public class BlobObject
extends DefaultObject {
    private String xpath;
    private DocumentModel doc;

    protected void initialize(Object ... args) {
        super.initialize(args);
        if (args.length == 2) {
            this.xpath = (String)args[0];
            this.doc = (DocumentModel)args[1];
        }
    }

    public <A> A getAdapter(Class<A> adapter) {
        if (adapter.isAssignableFrom(Blob.class)) {
            try {
                return adapter.cast(this.blob(this.xpath));
            }
            catch (ClientException e) {
                throw WebException.wrap((String)("Could not find any blob: " + this.xpath), (Throwable)e);
            }
        }
        return (A)super.getAdapter(adapter);
    }

    protected Blob blob(String xpath) throws ClientException {
        return (Blob)this.doc.getPropertyValue(xpath);
    }

    @GET
    public Response doGet(@Context Request request) throws ClientException {
        if (this.xpath == null) {
            this.xpath = this.getXpathFromRequest();
        }
        try {
            Response.ResponseBuilder builder;
            Property p = this.doc.getProperty(this.xpath);
            Blob blob = (Blob)p.getValue();
            if (blob == null) {
                throw new WebResourceNotFoundException("No attached file at " + this.xpath);
            }
            String fileName = blob.getFilename();
            if (fileName == null && (p = p.getParent()).isComplex()) {
                try {
                    fileName = (String)((Object)p.getValue("filename"));
                }
                catch (PropertyException e) {
                    fileName = "Unknown";
                }
            }
            EntityTag etag = null;
            if (blob instanceof SQLBlob) {
                etag = new EntityTag(((SQLBlob)blob).getBinary().getDigest());
            }
            if (etag != null && (builder = request.evaluatePreconditions(etag)) != null) {
                return builder.build();
            }
            String contentDisposition = ServletHelper.getRFC2231ContentDisposition((HttpServletRequest)this.ctx.getRequest(), (String)fileName);
            Response.ResponseBuilder builder2 = Response.ok((Object)blob).header("Content-Disposition", (Object)contentDisposition).type(blob.getMimeType());
            if (etag != null) {
                builder2.tag(etag);
            }
            return builder2.build();
        }
        catch (ClientException e) {
            throw WebException.wrap((String)"Failed to get the attached file", (Throwable)e);
        }
    }

    private String getXpathFromRequest() {
        FormData form = this.ctx.getForm();
        String propertyXpath = form.getString("property");
        if (propertyXpath == null && this.doc.hasSchema("file")) {
            propertyXpath = "file:content";
        }
        return propertyXpath;
    }

    @DELETE
    public Response doDelete() {
        try {
            this.doc.getProperty(this.xpath).remove();
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(this.doc);
            session.save();
        }
        catch (PropertyException e) {
            throw WebException.wrap((String)("Failed to delete attached file into property: " + this.xpath), (Throwable)e);
        }
        catch (ClientException e) {
            throw WebException.wrap((String)("Failed to delete attached file into property: " + this.xpath), (Throwable)e);
        }
        return Response.noContent().build();
    }

    @PUT
    public Response doPut() {
        FormData form = this.ctx.getForm();
        Blob blob = form.getFirstBlob();
        if (blob == null) {
            throw new IllegalArgumentException("Could not find any uploaded file");
        }
        try {
            Property p = this.doc.getProperty(this.xpath);
            if (p.isList()) {
                throw new ClientException("Can't update blob on list property");
            }
            if ("file".equals(p.getSchema().getName())) {
                p.getParent().get("filename").setValue((Object)blob.getFilename());
            }
            p.setValue((Object)blob);
            this.doc.putContextData("VersioningOption", (Serializable)form.getVersioningOption());
            CoreSession session = this.ctx.getCoreSession();
            session.saveDocument(this.doc);
            session.save();
            return Response.ok((Object)"blob updated").build();
        }
        catch (ClientException e) {
            throw WebException.wrap((String)"Failed to attach file", (Throwable)e);
        }
    }
}

